/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.util;

import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;

public class ShowProgress {
    public static final int SHOW_EVERY = 10000;
    public static final int SHOW_EVERY_LINE = 1000000;
    int showEvery = 100000;
    int showEveryLine = 100 * this.showEvery;
    long timeStart;

    public ShowProgress() {
        this(10000, 1000000);
        this.timeStart = System.currentTimeMillis();
    }

    public ShowProgress(int showEvery, int showEveryLine) {
        this.showEvery = showEvery;
        this.showEveryLine = showEveryLine;
    }

    public void tick(int count) {
        this.tick(count, (VcfEntry)null);
    }

    public void tick(int count, VariantVcfEntry varVcf) {
        this.tick(count, varVcf.getVcfEntry());
    }

    public void tick(int count, VcfEntry vcfEntry) {
        if (count % this.showEvery == 0) {
            if (count % this.showEveryLine == 0) {
                System.err.println(" " + String.format("%,d", count) + " " + (String)(vcfEntry != null ? vcfEntry.getChromosomeName() + ":" + vcfEntry.getStart() + "\t" : ""));
            } else {
                System.err.print('.');
                System.err.flush();
            }
        }
    }

    public double elapsedSec() {
        return (double)(System.currentTimeMillis() - this.timeStart) / 1000.0;
    }
}

