/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.util;

import java.util.ArrayList;
import java.util.Random;
import org.snpeff.util.Tuple;
import org.snpsift.annotate.mem.VariantCategory;

public class RandomUtil {
    public static final String[] ACGT = new String[]{"A", "C", "G", "T"};
    public static final int SHORT_VARIANT_LEN = 5;
    double nullRatio = 0.1;
    long seed;
    Random rand;

    public RandomUtil() {
        this(42);
    }

    public RandomUtil(int seed) {
        this.seed = seed;
        this.rand = new Random(seed);
    }

    public void reset() {
        this.rand = new Random(this.seed);
    }

    public double rand() {
        return this.rand.nextDouble();
    }

    public String randAcgt() {
        return ACGT[this.rand.nextInt(ACGT.length)];
    }

    public String randBase(String notBase) {
        String base = this.randAcgt();
        while (base.equals(notBase)) {
            base = this.randAcgt();
        }
        return base;
    }

    public String randBases(int len) {
        return this.randBases(len, null);
    }

    public String randBases(int len, String notBases) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < len; ++i2) {
            String randBase = null;
            if (notBases != null && i2 < notBases.length()) {
                String notBase = notBases.substring(i2, i2 + 1);
                randBase = this.randBase(notBase);
            } else {
                randBase = this.randAcgt();
            }
            sb.append(randBase);
        }
        return sb.toString();
    }

    public boolean randBool() {
        return this.rand.nextDouble() <= 0.5;
    }

    public Boolean randBoolOrNull() {
        return this.rand.nextDouble() < this.nullRatio ? null : Boolean.valueOf(this.randBool());
    }

    public char randChar() {
        return (char)(this.randInt(26) + 65);
    }

    public Character randCharOrNull() {
        return this.rand.nextDouble() < this.nullRatio ? null : Character.valueOf(this.randChar());
    }

    public double randDouble(double maxDouble) {
        return this.rand.nextDouble() * maxDouble;
    }

    public Double randDoubleOrNull() {
        return this.rand.nextDouble() < this.nullRatio ? null : Double.valueOf(this.rand.nextDouble());
    }

    public String randEnum(ArrayList<String> enumStrings) {
        int ord = this.randInt(enumStrings.size());
        return enumStrings.get(ord);
    }

    public String randEnumOrNull(ArrayList<String> enumStrings) {
        return this.rand.nextDouble() < this.nullRatio ? null : this.randEnum(enumStrings);
    }

    public int randInt() {
        return this.rand.nextInt();
    }

    public int randInt(int maxInt) {
        return this.rand.nextInt(maxInt);
    }

    public Integer randIntOrNull() {
        return this.rand.nextDouble() < this.nullRatio ? null : Integer.valueOf(this.rand.nextInt());
    }

    public Integer randIntOrNull(int maxInt) {
        return this.rand.nextDouble() < this.nullRatio ? null : Integer.valueOf(this.randInt(maxInt));
    }

    public long randLong() {
        return this.rand.nextLong();
    }

    public long randLong(long maxLong) {
        return this.rand.nextLong() % maxLong;
    }

    public Long randLongOrNull() {
        return this.rand.nextDouble() < this.nullRatio ? null : Long.valueOf(this.randLong());
    }

    public Long randLongOrNull(long maxLong) {
        return this.rand.nextDouble() < this.nullRatio ? null : Long.valueOf(this.randLong(maxLong));
    }

    public String randString(int maxLen) {
        int len = this.rand.nextInt(maxLen);
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < len; ++i2) {
            sb.append(this.randChar());
        }
        return sb.toString();
    }

    public String randStringOrNull() {
        if (this.rand.nextDouble() < this.nullRatio) {
            return null;
        }
        return this.randString(256);
    }

    public String randStringOrNull(int maxLen) {
        return this.rand.nextDouble() < this.nullRatio ? null : this.randString(maxLen);
    }

    public Tuple<String, String> randVariant(VariantCategory variantCategory) {
        String ref = this.randVariantRef(variantCategory);
        String alt = this.randVariantAlt(variantCategory, ref);
        return new Tuple<String, String>(ref, alt);
    }

    public String randVariantAlt(VariantCategory variantCategory, String ref) {
        switch (variantCategory) {
            case SNP_A: {
                return "A";
            }
            case SNP_C: {
                return "C";
            }
            case SNP_G: {
                return "G";
            }
            case SNP_T: {
                return "T";
            }
            case MNP: {
                return this.randBases(ref.length(), ref);
            }
            case INS: {
                int len = this.randInt(5) + 1;
                return this.randAcgt() + this.randBases(len);
            }
            case DEL: {
                return "";
            }
            case MIXED: {
                int len = this.randInt(5) + 2;
                while (len == ref.length()) {
                    len = this.randInt(10) + 2;
                }
                return this.randBases(len, ref);
            }
        }
        throw new RuntimeException("Unimplemented for variant category " + String.valueOf((Object)variantCategory));
    }

    public String randVariantRef(VariantCategory variantCategory) {
        switch (variantCategory) {
            case SNP_A: {
                return this.randBase("A");
            }
            case SNP_C: {
                return this.randBase("C");
            }
            case SNP_G: {
                return this.randBase("G");
            }
            case SNP_T: {
                return this.randBase("T");
            }
            case MNP: {
                int len = this.randInt(5) + 2;
                return this.randBases(len);
            }
            case INS: {
                return "";
            }
            case DEL: {
                int len = this.randInt(5) + 1;
                return this.randBases(len);
            }
            case MIXED: {
                int len = this.randInt(5) + 2;
                return this.randBases(len);
            }
        }
        throw new RuntimeException("Unimplemented for variant category " + String.valueOf((Object)variantCategory));
    }

    public void setNullRatio(double nullRatio) {
        this.nullRatio = nullRatio;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setRand(Random rand) {
        this.rand = rand;
    }
}

