/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.pedigree;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.snpeff.ped.Sex;
import org.snpeff.ped.TfamEntry;

public class Individual
implements Comparable<Individual> {
    HashSet<Individual> childs;
    ArrayList<Individual> childsSorted;
    int order = Integer.MIN_VALUE;
    int depth = -1;
    int descendants = Integer.MIN_VALUE;
    String id;
    String familyId;
    String label;
    Point position;
    Sex sex;
    String color = "white";
    Boolean affected = null;
    Individual father;
    Individual mother;

    public Individual(TfamEntry tfamEntry) {
        this.id = tfamEntry.getId();
        this.sex = tfamEntry.getSex();
        this.familyId = tfamEntry.getFamilyId();
        this.label = this.id;
        this.affected = tfamEntry.isMissing() ? null : Boolean.valueOf(tfamEntry.isCase());
        this.childs = new HashSet();
        this.position = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.label = this.id;
    }

    protected void addChild(Individual ind) {
        this.childs.add(ind);
        this.childsSorted = null;
    }

    public int calcDepth() {
        int maxDepth = Math.max(0, this.depth);
        if (this.mother != null) {
            maxDepth = Math.max(maxDepth, this.mother.calcDepth() + 1);
        }
        if (this.father != null) {
            maxDepth = Math.max(maxDepth, this.father.calcDepth() + 1);
        }
        this.depth = maxDepth;
        return this.depth;
    }

    @Override
    public int compareTo(Individual ind) {
        return this.id.compareTo(ind.getId());
    }

    int descendants() {
        if (this.descendants >= 0) {
            return this.descendants;
        }
        this.descendants = this.getChilds().size();
        for (Individual ch : this.getChilds()) {
            this.descendants += ch.descendants();
        }
        return this.descendants;
    }

    public Boolean getAffected() {
        return this.affected;
    }

    public Collection<Individual> getChilds() {
        if (this.childsSorted == null) {
            this.childsSorted = new ArrayList();
            this.childsSorted.addAll(this.childs);
            Collections.sort(this.childsSorted);
        }
        return this.childsSorted;
    }

    public ArrayList<Individual> getChilds(Individual spouse) {
        ArrayList<Individual> sharedChilds = new ArrayList<Individual>();
        if (spouse != null) {
            sharedChilds.addAll(this.getChilds());
            sharedChilds.retainAll(spouse.getChilds());
        } else {
            for (Individual ch : this.getChilds()) {
                if (ch.getMother() != null && ch.getFather() != null) continue;
                sharedChilds.add(ch);
            }
        }
        return sharedChilds;
    }

    public String getColor() {
        return this.color;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public Individual getFather() {
        return this.father;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public Individual getMother() {
        return this.mother;
    }

    public int getOrder() {
        return this.order;
    }

    public Point getPosition() {
        return this.position;
    }

    public Sex getSex() {
        return this.sex;
    }

    protected boolean hasOrder() {
        return this.order != Integer.MIN_VALUE;
    }

    public boolean hasPosition() {
        return this.position.x != Integer.MIN_VALUE && this.position.y != Integer.MIN_VALUE;
    }

    public boolean isDescendant(Individual ind) {
        return this.mother == ind || this.father == ind || this.mother != null && this.mother.isDescendant(ind) || this.father != null && this.father.isDescendant(ind);
    }

    public boolean isFemale() {
        return this.sex == Sex.Female;
    }

    public boolean isMale() {
        return this.sex == Sex.Male;
    }

    public boolean isRoot() {
        return this.mother == null && this.father == null;
    }

    boolean isSpouse(Individual ind) {
        for (Individual ch : this.childs) {
            if (ch.getMother() != null && ch.getMother().getId().equals(ind.getId())) {
                return true;
            }
            if (ch.getFather() == null || !ch.getFather().getId().equals(ind.getId())) continue;
            return true;
        }
        return false;
    }

    protected void removeChild(Individual ind) {
        this.childs.remove(ind);
        this.childsSorted = null;
    }

    Individual rootMother() {
        if (this.mother == null) {
            return null;
        }
        Individual mom = this.mother;
        Individual root = mom.rootMother();
        if (root != null) {
            return root;
        }
        return mom;
    }

    public void setAffected(Boolean affected) {
        this.affected = affected;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        for (Individual ch : this.childs) {
            ch.setDepth(depth + 1);
        }
    }

    public void setFather(Individual father) {
        if (father != null && !father.isMale()) {
            throw new RuntimeException("Error: Father is not male");
        }
        if (this.father != null) {
            this.father.removeChild(this);
        }
        this.father = father;
        if (father != null) {
            father.addChild(this);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMother(Individual mother) {
        if (mother != null && mother.isMale()) {
            throw new RuntimeException("Error: Individual '" + this.id + "' has non-female mother '" + mother.getId() + "'");
        }
        if (this.mother != null) {
            this.mother.removeChild(this);
        }
        this.mother = mother;
        if (mother != null) {
            mother.addChild(this);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public void sizeByDepth(int[] sizeByLevel) {
        int n = this.depth;
        sizeByLevel[n] = sizeByLevel[n] + 1;
        for (Individual ch : this.childs) {
            ch.sizeByDepth(sizeByLevel);
        }
    }

    public String toString() {
        return this.id + (String)(this.hasPosition() ? " [" + this.position.x + " , " + this.position.y + "]" : "");
    }

    public String toStringTree() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.id + " ");
        if (!this.childs.isEmpty()) {
            sb.append("[ ");
            for (Individual ch : this.getChilds()) {
                sb.append(ch.toStringTree() + ",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]");
        }
        return sb.toString();
    }
}

