/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang.function;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpsift.lang.Value;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.function.Function;

public class In
extends Function {
    ArrayList<HashSet<String>> sets;
    Expression expression;
    Expression setIdxExpr;

    public In(ArrayList<HashSet<String>> sets, Expression expression, Expression setIdxExpr) {
        super("in");
        this.sets = sets;
        this.expression = expression;
        this.setIdxExpr = setIdxExpr;
    }

    @Override
    public Value eval(VcfEntry vcfEntry) {
        String val = this.expression.eval(vcfEntry).asString();
        Value idx = this.setIdxExpr.eval(vcfEntry);
        Set set = this.sets.get((int)idx.asInt());
        return set.contains(val) ? Value.TRUE : Value.FALSE;
    }

    @Override
    public Value eval(VcfGenotype gt) {
        String val = this.expression.eval(gt).asString();
        Value idx = this.setIdxExpr.eval(gt);
        Set set = this.sets.get((int)idx.asInt());
        return set.contains(val) ? Value.TRUE : Value.FALSE;
    }

    @Override
    public String toString() {
        return String.valueOf(this.expression) + " " + this.operator + " SET[" + String.valueOf(this.setIdxExpr) + "]";
    }
}

