/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snpsift.lang.Value;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.expression.ExpressionBinary;

public class Match
extends ExpressionBinary {
    public Match(Expression left, Expression right) {
        super(left, right, "~=");
    }

    @Override
    protected Value evalOp(Value lval, Value rval) {
        if (lval.isNull() || rval.isNull()) {
            return Value.FALSE;
        }
        String value = lval.asString();
        boolean retVal = false;
        if (value.isEmpty()) {
            retVal = false;
        } else {
            String regexp = rval.asString();
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(value);
            retVal = matcher.find();
        }
        return new Value(this.negated ? !retVal : retVal);
    }
}

