/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang.expression;

import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpsift.lang.Value;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.expression.Field;
import org.snpsift.lang.expression.FieldIterator;

public class FieldSub
extends Field {
    Expression indexExpr;

    public FieldSub(String name, Expression indexExpr) {
        super(name);
        this.indexExpr = indexExpr;
    }

    protected int evalIndex(VcfEntry vcfEntry) {
        return this.evalIndex(vcfEntry, this.indexExpr);
    }

    protected int evalIndex(VcfEntry vcfEntry, Expression idxExpr) {
        Value idxVal = idxExpr.eval(vcfEntry);
        int index = (int)(idxVal.isString() ? (long)this.parseIndexField(idxVal.asString()) : idxVal.asInt());
        return index;
    }

    protected int evalIndex(VcfGenotype vcfGenotype) {
        return this.evalIndex(vcfGenotype, this.indexExpr);
    }

    protected int evalIndex(VcfGenotype vcfGenotype, Expression idxExpr) {
        Value idxVal = idxExpr.eval(vcfGenotype);
        int index = (int)(idxVal.isString() ? (long)this.parseIndexField(idxVal.asString()) : idxVal.asInt());
        return index;
    }

    @Override
    public String getFieldString(VcfEntry vcfEntry) {
        int index;
        String value = super.getFieldString(vcfEntry);
        if (value == null) {
            return (String)this.fieldNotFound(vcfEntry);
        }
        String[] sub = value.split(",");
        int idx = index = this.evalIndex(vcfEntry);
        if (index < 0) {
            FieldIterator.get().setMax(FieldIterator.IteratorType.VAR, sub.length - 1);
            FieldIterator.get().setType(index);
            idx = FieldIterator.get().get(FieldIterator.IteratorType.VAR);
        }
        if (sub.length <= idx) {
            return "";
        }
        return sub[idx];
    }

    @Override
    public String getFieldString(VcfGenotype vcfGenotype) {
        int index;
        String value = super.getFieldString(vcfGenotype);
        if (value == null) {
            return (String)this.gtFieldNotFound(vcfGenotype);
        }
        String[] sub = value.split(",");
        Value idxVal = this.indexExpr.eval(vcfGenotype);
        int idx = index = (int)(idxVal.isString() ? (long)this.parseIndexField(idxVal.asString()) : idxVal.asInt());
        if (index < 0) {
            FieldIterator.get().setMax(FieldIterator.IteratorType.GENOTYPE_VAR, sub.length - 1);
            FieldIterator.get().setType(index);
            idx = FieldIterator.get().get(FieldIterator.IteratorType.VAR);
        }
        if (sub.length <= idx) {
            return "";
        }
        return sub[idx];
    }

    @Override
    protected boolean isSub() {
        return true;
    }

    @Override
    public String toString() {
        return this.name + "[" + String.valueOf(this.indexExpr) + "]";
    }
}

