/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang.expression;

import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.expression.FieldIterator;
import org.snpsift.lang.expression.FieldSub;

public class FieldGenotype
extends FieldSub {
    public FieldGenotype(String name, Expression indexExpr) {
        super(name, indexExpr);
    }

    protected VcfGenotype evalGenotype(VcfEntry vcfEntry) {
        int genotypeIndex = this.evalIndex(vcfEntry);
        int maxIdx = vcfEntry.getVcfGenotypes().size() - 1;
        if (maxIdx < genotypeIndex) {
            throw new RuntimeException("Error: Genotype numer '" + genotypeIndex + "' does not exists. Max genotype number is '" + maxIdx + "'\n" + String.valueOf(vcfEntry));
        }
        int idx = genotypeIndex;
        if (genotypeIndex < 0) {
            FieldIterator.get().setMax(FieldIterator.IteratorType.GENOTYPE, vcfEntry.getVcfGenotypes().size() - 1);
            FieldIterator.get().setType(genotypeIndex);
            idx = FieldIterator.get().get(FieldIterator.IteratorType.GENOTYPE);
        }
        VcfGenotype vcfGenotype = vcfEntry.getVcfGenotype(idx);
        return vcfGenotype;
    }

    @Override
    public String getFieldString(VcfEntry vcfEntry) {
        VcfGenotype vcfGenotype = this.evalGenotype(vcfEntry);
        String value = this.getValue(vcfGenotype);
        if (value == null && this.exceptionIfNotFound) {
            throw new RuntimeException("Error: Genotype field '" + this.name + "' not available in this entry.\n\t" + String.valueOf(this));
        }
        return value;
    }

    @Override
    public String getFieldString(VcfGenotype vcfGenotype) {
        String value = this.getValue(vcfGenotype);
        if (value == null) {
            return (String)this.gtFieldNotFound(vcfGenotype);
        }
        return value;
    }

    String getValue(VcfGenotype vcfGenotype) {
        if (this.name == null) {
            return vcfGenotype.toString();
        }
        return vcfGenotype.get(this.name);
    }

    @Override
    protected boolean isSub() {
        return false;
    }

    @Override
    public String toString() {
        return "GEN[" + String.valueOf(this.indexExpr) + "]" + (String)(this.name != null ? "." + this.name : "");
    }
}

