/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang.expression;

import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpsift.lang.Value;
import org.snpsift.lang.expression.Expression;

public abstract class ExpressionBinary
extends Expression {
    protected Expression left;
    protected Expression right;

    public ExpressionBinary(Expression left, Expression right, String operator) {
        super(operator);
        this.right = right;
        this.left = left;
    }

    @Override
    public Value eval(VcfEntry vcfEntry) {
        Value lval = this.left.eval(vcfEntry);
        Value rval = this.right != null ? this.right.eval(vcfEntry) : null;
        return this.evalOp(lval, rval);
    }

    @Override
    public Value eval(VcfGenotype gt) {
        Value lval = this.left.eval(gt);
        Value rval = this.right != null ? this.right.eval(gt) : null;
        return this.evalOp(lval, rval);
    }

    protected abstract Value evalOp(Value var1, Value var2);

    public String toString() {
        return "( " + String.valueOf(this.left) + " " + this.operator + " " + String.valueOf(this.right) + " )";
    }
}

