/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang;

import java.util.ArrayList;
import java.util.HashSet;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.EffFormatVersion;
import org.snpsift.antlr.SnpSiftLexer;
import org.snpsift.antlr.SnpSiftParser;
import org.snpsift.lang.expression.And;
import org.snpsift.lang.expression.Div;
import org.snpsift.lang.expression.Eq;
import org.snpsift.lang.expression.Exists;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.expression.Field;
import org.snpsift.lang.expression.FieldConstant;
import org.snpsift.lang.expression.FieldEff;
import org.snpsift.lang.expression.FieldGenotype;
import org.snpsift.lang.expression.FieldGenotypeSub;
import org.snpsift.lang.expression.FieldLof;
import org.snpsift.lang.expression.FieldNmd;
import org.snpsift.lang.expression.FieldSub;
import org.snpsift.lang.expression.Ge;
import org.snpsift.lang.expression.Gt;
import org.snpsift.lang.expression.Has;
import org.snpsift.lang.expression.Le;
import org.snpsift.lang.expression.Literal;
import org.snpsift.lang.expression.Lt;
import org.snpsift.lang.expression.Match;
import org.snpsift.lang.expression.Minus;
import org.snpsift.lang.expression.Mod;
import org.snpsift.lang.expression.Na;
import org.snpsift.lang.expression.Neq;
import org.snpsift.lang.expression.Not;
import org.snpsift.lang.expression.NotMatch;
import org.snpsift.lang.expression.Or;
import org.snpsift.lang.expression.Plus;
import org.snpsift.lang.expression.Times;
import org.snpsift.lang.expression.Xor;
import org.snpsift.lang.function.CountHet;
import org.snpsift.lang.function.CountHom;
import org.snpsift.lang.function.CountRef;
import org.snpsift.lang.function.CountVariant;
import org.snpsift.lang.function.Function;
import org.snpsift.lang.function.FunctionBoolGenotype;
import org.snpsift.lang.function.In;
import org.snpsift.lang.function.IsHet;
import org.snpsift.lang.function.IsHom;
import org.snpsift.lang.function.IsRef;
import org.snpsift.lang.function.IsVariant;

public class LangFactory {
    protected static boolean debug = false;
    ArrayList<HashSet<String>> sets = new ArrayList();
    EffFormatVersion formatVersion;
    boolean exceptionIfNotFound = false;

    public LangFactory() {
        this.sets = new ArrayList();
    }

    public LangFactory(ArrayList<HashSet<String>> sets, EffFormatVersion formatVersion, boolean exceptionIfNotFound) {
        this.sets = sets;
        this.formatVersion = formatVersion;
        this.exceptionIfNotFound = exceptionIfNotFound;
    }

    public Expression compile(String expression) {
        if (debug) {
            Log.debug("Creating AST: " + expression);
        }
        SnpSiftLexer lexer = null;
        SnpSiftParser parser = null;
        SnpSiftParser.CompilationUnitContext tree = null;
        try {
            ANTLRInputStream input = new ANTLRInputStream(expression);
            lexer = new SnpSiftLexer(this, input){

                @Override
                public void recover(LexerNoViableAltException e) {
                    throw new RuntimeException(e);
                }
            };
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            parser = new SnpSiftParser(tokens);
            tree = parser.compilationUnit();
            if (tree == null) {
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (debug) {
            Log.debug("Tree: " + tree.toStringTree());
        }
        return this.expressionFactory(tree);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression expressionFactory(ParseTree tree) {
        Class<?> leaveClass = tree.getClass();
        String leaveName = leaveClass.getSimpleName();
        if (debug) {
            Log.debug("\n\tLeaveClassName : " + leaveName + "\n\tTxt            : " + tree.getText() + "\n\tTree           : " + tree.toStringTree());
            for (int i2 = 0; i2 < tree.getChildCount(); ++i2) {
                System.err.println("\t\tChild[" + i2 + "] : " + tree.getChild(i2).getText() + "\t\t" + tree.getChild(i2).getClass().getSimpleName());
            }
        }
        Expression expression = null;
        if (leaveClass == SnpSiftParser.CompilationUnitContext.class) {
            expression = this.expressionFactory(tree.getChild(0));
        } else if (leaveClass == SnpSiftParser.ExpressionParenContext.class) {
            expression = this.expressionFactory(tree.getChild(1));
        } else if (leaveClass == SnpSiftParser.ExpressionLogicContext.class) {
            String op = ((SnpSiftParser.ExpressionLogicContext)tree).op.getText();
            if (debug) {
                Log.debug("Logic operator: '" + op + "'");
            }
            Expression l = this.expressionFactory(tree.getChild(0));
            Expression r = this.expressionFactory(tree.getChild(2));
            if (op.equals("&") || op.equals("&&")) {
                expression = new And(l, r);
            } else if (op.equals("|") || op.equals("||")) {
                expression = new Or(l, r);
            } else {
                if (!op.equals("^") && !op.equals("~")) throw new RuntimeException("Unknown operator '" + op + "'");
                expression = new Xor(l, r);
            }
        } else if (leaveClass == SnpSiftParser.ExpressionTimesContext.class) {
            String op = ((SnpSiftParser.ExpressionTimesContext)tree).op.getText();
            if (debug) {
                Log.debug("Multiplication operator: '" + op + "'");
            }
            Expression left = this.expressionFactory(tree.getChild(0));
            Expression right = this.expressionFactory(tree.getChild(2));
            if (op.equals("*")) {
                expression = new Times(left, right);
            } else if (op.equals("/")) {
                expression = new Div(left, right);
            } else {
                if (!op.equals("%")) throw new RuntimeException("Unknown operator '" + op + "'");
                expression = new Mod(left, right);
            }
        } else if (leaveClass == SnpSiftParser.ExpressionPlusContext.class) {
            String op = ((SnpSiftParser.ExpressionPlusContext)tree).op.getText();
            if (debug) {
                Log.debug("Plus operator: '" + op + "'");
            }
            Expression left = this.expressionFactory(tree.getChild(0));
            Expression right = this.expressionFactory(tree.getChild(2));
            if (op.equals("+")) {
                expression = new Plus(left, right);
            } else {
                if (!op.equals("-")) throw new RuntimeException("Unknown operator '" + op + "'");
                expression = new Minus(left, right);
            }
        } else if (leaveClass == SnpSiftParser.ExpressionCompContext.class) {
            String op = ((SnpSiftParser.ExpressionCompContext)tree).op.getText();
            if (debug) {
                Log.debug("Compare operator: '" + op + "'");
            }
            Expression left = this.expressionFactory(tree.getChild(0));
            Expression right = this.expressionFactory(tree.getChild(2));
            if (op.equals("<")) {
                expression = new Lt(left, right);
            } else if (op.equals("<=")) {
                expression = new Le(left, right);
            } else if (op.equals(">")) {
                expression = new Gt(left, right);
            } else if (op.equals(">=")) {
                expression = new Ge(left, right);
            } else if (op.equals("=") || op.equals("==")) {
                expression = new Eq(left, right);
            } else if (op.equals("!=")) {
                expression = new Neq(left, right);
            } else if (op.equals("=~")) {
                expression = new Match(left, right);
            } else if (op.equals("!~")) {
                expression = new NotMatch(left, right);
            } else {
                if (!op.equals("has")) throw new RuntimeException("Unknown operator '" + op + "'");
                expression = new Has(left, right);
            }
        } else if (leaveClass == SnpSiftParser.ExpressionExistsContext.class) {
            String op = ((SnpSiftParser.ExpressionExistsContext)tree).op.getText();
            Expression expr = this.expressionFactory(tree.getChild(1));
            if (op.equalsIgnoreCase("exists")) {
                expression = new Exists(expr);
            } else {
                if (!op.equalsIgnoreCase("na")) throw new RuntimeException("Unknown operator '" + op + "'");
                expression = new Na(expr);
            }
        } else if (leaveClass == SnpSiftParser.ExpressionUnaryContext.class) {
            String op = ((SnpSiftParser.ExpressionUnaryContext)tree).op.getText();
            if (debug) {
                Log.debug("Unary operator: '" + op + "'");
            }
            Expression expr = this.expressionFactory(tree.getChild(1));
            if (op.equals("!")) {
                expression = new Not(expr);
            } else if (op.equals("+")) {
                expression = new Plus(expr);
            } else {
                if (!op.equals("-")) throw new RuntimeException("Unknown operator '" + leaveName + "'");
                expression = new Minus(expr);
            }
        } else if (leaveClass == SnpSiftParser.VarReferenceContext.class || leaveClass == SnpSiftParser.VarReferenceListContext.class || leaveClass == SnpSiftParser.VarReferenceListSubContext.class) {
            expression = this.fieldFactory(tree);
        } else if (leaveClass == SnpSiftParser.LiteralBoolContext.class) {
            String str = tree.getChild(0).getText();
            expression = new Literal(Gpr.parseBoolSafe(str));
        } else if (leaveClass == SnpSiftParser.LiteralIntContext.class) {
            String str = tree.getChild(0).getText();
            expression = new Literal(Gpr.parseLongSafe(str));
        } else if (leaveClass == SnpSiftParser.LiteralFloatContext.class) {
            String str = tree.getChild(0).getText();
            expression = new Literal(Gpr.parseDoubleSafe(str));
        } else if (leaveClass == SnpSiftParser.LiteralStringContext.class) {
            String str = tree.getChild(0).getText();
            expression = new Literal(str);
        } else if (leaveClass == SnpSiftParser.FunctionCallContext.class) {
            expression = this.functionFactory(tree);
        } else if (leaveClass == SnpSiftParser.ExpressionSetContext.class) {
            expression = this.expressionSetFactory(tree);
        } else {
            if (leaveClass != SnpSiftParser.LiteralIndexContext.class) throw new RuntimeException("Unknown expression '" + leaveName + "'");
            String txt = tree.getText();
            expression = new Literal(txt);
        }
        if (!debug) return expression;
        Log.debug("Expression: " + String.valueOf(expression));
        return expression;
    }

    public Function expressionSetFactory(ParseTree tree) {
        if (debug) {
            Class<?> leaveClass = tree.getClass();
            String leaveName = leaveClass.getSimpleName();
            Log.debug("\n\tLeaveClassName : " + leaveName + "\n\tTxt            : " + tree.getText() + "\n\tTree           : " + tree.toStringTree());
            for (int i2 = 0; i2 < tree.getChildCount(); ++i2) {
                System.err.println("\t\tChild[" + i2 + "] : " + tree.getChild(i2).getText() + "\t\t" + tree.getChild(i2).getClass().getSimpleName());
            }
        }
        Expression expr = this.expressionFactory(tree.getChild(0));
        Expression exprSetIdx = this.expressionFactory(tree.getChild(4));
        In fun = null;
        fun = new In(this.sets, expr, exprSetIdx);
        return fun;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Field fieldFactory(ParseTree tree) {
        Class<?> leaveClass = tree.getClass();
        String leaveName = leaveClass.getSimpleName();
        if (debug) {
            Log.debug("\n\tLeaveClassName : " + leaveName + "\n\tTxt            : " + tree.getText() + "\n\tTree           : " + tree.toStringTree());
            for (int i2 = 0; i2 < tree.getChildCount(); ++i2) {
                System.err.println("\t\tChild[" + i2 + "] : " + tree.getChild(i2).getText() + "\t\t" + tree.getChild(i2).getClass().getSimpleName());
            }
        }
        Field field = null;
        if (leaveClass == SnpSiftParser.VarReferenceContext.class) {
            String name = tree.getChild(0).getText();
            field = FieldConstant.isConstantField(name) ? FieldConstant.factory(name) : new Field(name);
        } else if (leaveClass == SnpSiftParser.VarReferenceListContext.class) {
            String name = tree.getChild(0).getText();
            Expression idxExpr = this.expressionFactory(tree.getChild(2));
            field = name.equalsIgnoreCase("gen") ? new FieldGenotype(null, idxExpr) : (name.equalsIgnoreCase("ann") || name.equalsIgnoreCase("eff") ? new FieldEff(null, idxExpr, this.formatVersion, name) : (name.equalsIgnoreCase("lof") ? new FieldLof(null, idxExpr) : (name.equalsIgnoreCase("nmd") ? new FieldNmd(null, idxExpr) : new FieldSub(name, idxExpr))));
        } else {
            if (leaveClass != SnpSiftParser.VarReferenceListSubContext.class) throw new RuntimeException("Unknown field '" + leaveName + "'");
            String name = tree.getChild(0).getText();
            Expression idxExpr = this.expressionFactory(tree.getChild(2));
            ParseTree subTree = tree.getChild(4);
            String subName = subTree.getChild(0).getText();
            if (tree.getChild(4).getClass() == SnpSiftParser.VarReferenceListContext.class) {
                Expression idxExpr2 = this.expressionFactory(subTree.getChild(2));
                field = new FieldGenotypeSub(subName, idxExpr, idxExpr2);
            } else if (name.equalsIgnoreCase("gen")) {
                field = new FieldGenotype(subName, idxExpr);
            } else if (name.equalsIgnoreCase("ann") || name.equalsIgnoreCase("eff")) {
                field = new FieldEff(subName, idxExpr, this.formatVersion, name);
            } else if (name.equalsIgnoreCase("lof")) {
                field = new FieldLof(subName, idxExpr);
            } else {
                if (!name.equalsIgnoreCase("nmd")) throw new RuntimeException("Could not create field '" + tree.getText() + "'");
                field = new FieldNmd(subName, idxExpr);
            }
        }
        field.setExceptionIfNotFound(this.exceptionIfNotFound);
        return field;
    }

    public FunctionBoolGenotype functionBoolGenotypeFactory(ParseTree tree) {
        String leaveName = tree.getChild(0).getText();
        if (debug) {
            Log.debug("\n\tLeaveClassName : " + leaveName + "\n\tTxt            : " + tree.getText() + "\n\tTree           : " + tree.toStringTree());
            for (int i2 = 0; i2 < tree.getChildCount(); ++i2) {
                System.err.println("\t\tChild[" + i2 + "] : " + tree.getChild(i2).getText());
            }
        }
        FunctionBoolGenotype fun = null;
        ParseTree subTree = tree.getChild(2);
        if (!subTree.getChild(0).getText().equalsIgnoreCase("GEN")) {
            throw new RuntimeException("Function '" + leaveName + "' only acceps a genotype as index");
        }
        Expression exprGenIdx = this.expressionFactory(subTree.getChild(2));
        if (leaveName.equalsIgnoreCase("isHom")) {
            fun = new IsHom(exprGenIdx);
        } else if (leaveName.equalsIgnoreCase("isHet")) {
            fun = new IsHet(exprGenIdx);
        } else if (leaveName.equalsIgnoreCase("isRef")) {
            fun = new IsRef(exprGenIdx);
        } else if (leaveName.equalsIgnoreCase("isVariant")) {
            fun = new IsVariant(exprGenIdx);
        } else {
            throw new RuntimeException("Unknown expression '" + leaveName + "'");
        }
        return fun;
    }

    public Function functionFactory(ParseTree tree) {
        String leaveName = tree.getChild(0).getText();
        if (leaveName.equalsIgnoreCase("isHom") || leaveName.equalsIgnoreCase("isHet") || leaveName.equalsIgnoreCase("isRef") || leaveName.equalsIgnoreCase("isVariant")) {
            return this.functionBoolGenotypeFactory(tree);
        }
        if (leaveName.equalsIgnoreCase("countHom") || leaveName.equalsIgnoreCase("countHet") || leaveName.equalsIgnoreCase("countRef") || leaveName.equalsIgnoreCase("countVariant")) {
            return this.functionVcfEntryFactory(tree);
        }
        throw new RuntimeException("Unknown function '" + leaveName + "'");
    }

    public Function functionVcfEntryFactory(ParseTree tree) {
        String leaveName = tree.getChild(0).getText();
        if (debug) {
            Log.debug("\n\tLeaveClassName : " + leaveName + "\n\tTxt            : " + tree.getText() + "\n\tTree           : " + tree.toStringTree());
            for (int i2 = 0; i2 < tree.getChildCount(); ++i2) {
                System.err.println("\t\tChild[" + i2 + "] : " + tree.getChild(i2).getText());
            }
        }
        Function func = null;
        if (leaveName.equalsIgnoreCase("countHom")) {
            func = new CountHom();
        } else if (leaveName.equalsIgnoreCase("countHet")) {
            func = new CountHet();
        } else if (leaveName.equalsIgnoreCase("countRef")) {
            func = new CountRef();
        } else if (leaveName.equalsIgnoreCase("countVariant")) {
            func = new CountVariant();
        } else {
            throw new RuntimeException("Unknown expression '" + leaveName + "'");
        }
        if (debug) {
            Log.debug("vcfExpression: " + String.valueOf(func));
        }
        return func;
    }
}

