/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.hwe;

import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;
import org.snpsift.SnpSift;
import org.snpsift.hwe.VcfHwe;

public class SnpSiftCmdHwe
extends SnpSift {
    public static final int SHOW_EVERY = 1000;

    public static void main(String[] args) {
        SnpSiftCmdHwe vcfhwe = new SnpSiftCmdHwe(args);
        vcfhwe.run();
    }

    public SnpSiftCmdHwe() {
    }

    public SnpSiftCmdHwe(String[] args) {
        super(args);
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> addh = super.headers();
        addh.add(new VcfHeaderInfo("HWE", VcfInfoType.Float, "1", "HardyWeinberg 'p'"));
        addh.add(new VcfHeaderInfo("HWEP", VcfInfoType.Float, "1", "HardyWeinberg p-value using Fisher exact test"));
        addh.add(new VcfHeaderInfo("HHWEPCHIWE", VcfInfoType.Float, "1", "HardyWeinberg p-value using Chi sqaure approximation"));
        return addh;
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        for (int argc = 0; argc < args.length; ++argc) {
            String arg = args[argc];
            if (this.isOpt(arg)) {
                if (arg.equals("-h") || args[argc].equalsIgnoreCase("-help")) {
                    this.usage(null);
                    continue;
                }
                if (arg.equals("-v")) {
                    this.verbose = true;
                    continue;
                }
                if (arg.equals("-q")) {
                    this.verbose = false;
                    continue;
                }
                if (arg.equals("-d")) {
                    this.debug = false;
                    continue;
                }
                this.usage("Unknown option '" + args[argc] + "'");
                continue;
            }
            this.vcfInputFile = args[argc++];
        }
        if (this.vcfInputFile == null) {
            this.vcfInputFile = "-";
        }
    }

    @Override
    public boolean run() {
        Log.info("Reading '" + this.vcfInputFile + "'. Running single threaded mode.");
        VcfFileIterator vcfFile = new VcfFileIterator(this.vcfInputFile);
        vcfFile.setDebug(this.debug);
        VcfHwe vcfHwe = new VcfHwe();
        VcfHwe.debug = this.debug;
        int entryNum = 1;
        for (VcfEntry vcfEntry : vcfFile) {
            if (entryNum == 1) {
                this.headers();
                String headerStr = vcfFile.getVcfHeader().toString();
                if (!headerStr.isEmpty()) {
                    System.out.println(headerStr);
                }
            }
            vcfHwe.hwe(vcfEntry, true);
            System.out.println(vcfEntry);
            Gpr.showMark(entryNum++, 1000);
        }
        Log.info("Done: " + entryNum + " entries processed.");
        return true;
    }

    @Override
    public void usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("Error: " + errMsg);
        }
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar hwe [-v] [-q] [file.vcf]");
        System.err.println("\t-q       : Be quite");
        System.err.println("\t-v       : Be verbose");
        System.exit(1);
    }
}

