/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.fileIterator;

import java.util.HashMap;
import java.util.Map;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.fileIterator.DbNsfp;

public class DbNsfpEntry
extends Variant {
    private static final long serialVersionUID = -3275792763917755927L;
    DbNsfp dbNsfp;
    String line;
    Map<String, String> values;

    public DbNsfpEntry(DbNsfp dbNsfp, String line) {
        this.dbNsfp = dbNsfp;
        this.line = line;
        this.parseChrPosRefAlt();
    }

    public static String[] splitValuesField(String value) {
        if (value.contains(",")) {
            return value.split(",");
        }
        return value.split(";");
    }

    public void add(String columnName, String valuesToAdd) {
        if (valuesToAdd.isEmpty()) {
            valuesToAdd = ".";
        } else if (valuesToAdd.indexOf(59) >= 0) {
            valuesToAdd = valuesToAdd.replace(';', '\t');
        } else if (valuesToAdd.indexOf(44) >= 0) {
            valuesToAdd = valuesToAdd.replace(',', '\t');
        }
        this.values.put(columnName, valuesToAdd);
    }

    @Override
    public DbNsfpEntry cloneShallow() {
        return (DbNsfpEntry)super.cloneShallow();
    }

    public String getVcfInfo(String key) {
        String val;
        if (this.values == null) {
            this.parseKeyValues();
        }
        if ((val = this.values.get(key)) == null) {
            return null;
        }
        if (val.indexOf(9) < 0) {
            return VcfEntry.vcfInfoValueSafe(val);
        }
        String[] vals = val.split("\t");
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (i2 > 0) {
                sb.append(",");
            }
            sb.append(VcfEntry.vcfInfoValueSafe(vals[i2]));
        }
        return sb.toString();
    }

    public boolean hasValues(String allele) {
        return this.values.containsKey(allele);
    }

    protected void parseChrPosRefAlt() {
        String[] vals = this.line.split("\t", -1);
        String chromosome = vals[this.dbNsfp.getChromosomeIdx()];
        this.parent = this.dbNsfp.getChromosome(chromosome);
        this.start = this.end = this.parsePosition(vals[this.dbNsfp.getStartIdx()]);
        this.variantType = Variant.VariantType.SNP;
        this.ref = vals[this.dbNsfp.getRefIdx()];
        this.alt = this.genotype = vals[this.dbNsfp.getAltIdx()];
    }

    protected void parseKeyValues() {
        String[] vals = this.line.split("\t", -1);
        this.values = new HashMap<String, String>();
        for (int i2 = 0; i2 < this.dbNsfp.getFieldCount(); ++i2) {
            this.add(this.dbNsfp.getFieldName(i2), vals[i2]);
        }
    }

    public int parsePosition(String posStr) {
        return Gpr.parseIntSafe(posStr) - 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStr()).append("\t").append('\n');
        for (String key : this.values.keySet()) {
            sb.append("\t").append(key).append(": '").append(this.values.get(key)).append("'\n");
        }
        return sb.toString();
    }
}

