/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.fileIterator;

import htsjdk.tribble.readers.TabixReader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfInfoType;
import org.snpsift.annotate.DbMarker;
import org.snpsift.fileIterator.DbNsfpEntry;

public class DbNsfp
implements DbMarker<Variant, DbNsfpEntry> {
    public static final String DATA_TYPES_CACHE_EXT = ".data_types";
    public static final int DATA_TYPES_MIN_LINES = 10000;
    public static final int DATA_TYPES_MAX_LINES = 100000;
    public static final String HEADER_PREFIX = "#";
    public static final String COLUMN_SEPARATOR = "\t";
    public static final char SUBFIELD_SEPARATOR_CHAR = ';';
    public static final String SUBFIELD_SEPARATOR = ";";
    public static final char SUBFIELD_SEPARATOR_CHAR_2 = ',';
    public static final String SUBFIELD_SEPARATOR_2 = ",";
    public static final String COLUMN_CHR_NAME = "chr";
    public static final String COLUMN_POS_NAME_v2 = "pos(1-coor)";
    public static final String COLUMN_POS_NAME_v3 = "pos(1-based)";
    public static final String ALT_NAME = "alt";
    public static final String REF_NAME = "ref";
    protected String fileName;
    protected boolean debug;
    protected boolean[] multipleValues = null;
    protected boolean verbose;
    protected int chromosomeIdx;
    protected int startIdx;
    protected int altIdx;
    protected int refIdx;
    protected int maxChrPosRefAltIdx;
    protected String[] fieldNames = null;
    protected VcfInfoType[] types = null;
    protected Genome genome;
    protected HashMap<String, Integer> names2index;
    protected TabixReader tabixReader;
    protected List<DbNsfpEntry> latestResults;
    protected Marker latestResultsInterval;

    public DbNsfp(String fileName) {
        this.fileName = fileName;
        this.genome = new Genome();
        this.latestResults = new LinkedList<DbNsfpEntry>();
        Genome genome = new Genome("NULL_GENOME");
        Chromosome chr = new Chromosome(genome, -1, -1, "NULL_CHROMOSOME");
        this.latestResultsInterval = new Marker(chr, -1, -1);
    }

    @Override
    public void close() {
        if (this.tabixReader != null) {
            this.tabixReader.close();
        }
        this.tabixReader = null;
    }

    protected boolean dataTypes() {
        boolean ok = false;
        String cacheFileName = this.fileName + DATA_TYPES_CACHE_EXT;
        if (!this.loadCachedDataTypes(cacheFileName)) {
            ok = this.guessDataTypes();
            this.saveDataTypesCache(cacheFileName);
        }
        this.forceMissingTypesAsString();
        return ok;
    }

    public void forceMissingTypesAsString() {
        for (int i2 = 0; i2 < this.types.length; ++i2) {
            if (this.types[i2] != null) continue;
            this.types[i2] = VcfInfoType.String;
        }
    }

    public int getAltIdx() {
        return this.altIdx;
    }

    public int getChrPosRefAltIdx() {
        return this.maxChrPosRefAltIdx;
    }

    public Chromosome getChromosome(String chromoName) {
        return this.genome.getOrCreateChromosome(chromoName);
    }

    public int getChromosomeIdx() {
        return this.chromosomeIdx;
    }

    public int getFieldCount() {
        return this.fieldNames.length;
    }

    public String getFieldName(int idx) {
        return this.fieldNames[idx];
    }

    public Set<String> getFieldNames() {
        return this.names2index.keySet();
    }

    public String[] getFieldNamesSorted() {
        return this.fieldNames;
    }

    public int getIndex(String name) {
        return this.names2index.get(name);
    }

    public HashMap<String, Integer> getNames2index() {
        return this.names2index;
    }

    public int getRefIdx() {
        return this.refIdx;
    }

    public int getStartIdx() {
        return this.startIdx;
    }

    public VcfInfoType[] getTypes() {
        return this.types;
    }

    protected VcfInfoType guessDataType(String value) {
        if (value == null || value.isEmpty() || value.equals(".")) {
            return null;
        }
        if (this.isMultipleValues(value)) {
            String[] values = DbNsfpEntry.splitValuesField(value);
            VcfInfoType type = null;
            for (String val : values) {
                VcfInfoType valType = this.guessDataType(val);
                if (type == null) {
                    type = valType;
                    continue;
                }
                if (valType == null || type == valType) continue;
                return null;
            }
            return type;
        }
        try {
            Long.parseLong(value);
            return VcfInfoType.Integer;
        }
        catch (Exception exception) {
            try {
                Double.parseDouble(value);
                return VcfInfoType.Float;
            }
            catch (Exception exception2) {
                if (value.length() == 1) {
                    return VcfInfoType.Character;
                }
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("no")) {
                    return VcfInfoType.Flag;
                }
                return VcfInfoType.String;
            }
        }
    }

    protected boolean guessDataTypes() {
        if (this.verbose) {
            Log.info("Guessing data types for file '" + this.fileName + "'");
        }
        boolean header = true;
        this.fieldNames = null;
        this.types = null;
        this.multipleValues = null;
        this.names2index = null;
        LineFileIterator lfi = new LineFileIterator(this.fileName);
        int entryNum = 0;
        for (String line : lfi) {
            if (line == null) {
                lfi.close();
                return false;
            }
            if (header) {
                header = false;
                this.parseHeader(line);
                continue;
            }
            if (this.multipleValues == null) {
                throw new RuntimeException("Cannot parse file '" + this.fileName + "'. Missing header?");
            }
            boolean done = true;
            String[] values = line.split(COLUMN_SEPARATOR, -1);
            for (int i2 = 0; i2 < this.fieldNames.length; ++i2) {
                VcfInfoType type = this.guessDataType(values[i2]);
                if (this.types[i2] == null) {
                    this.types[i2] = type;
                } else if (this.types[i2] == VcfInfoType.Integer && type == VcfInfoType.Float) {
                    this.types[i2] = type;
                } else if (type == VcfInfoType.String) {
                    this.types[i2] = type;
                }
                int n = i2;
                this.multipleValues[n] = this.multipleValues[n] | this.isMultipleValues(values[i2]);
                done &= this.types[i2] != null;
            }
            if (this.verbose) {
                Gpr.showMark(entryNum, 1000);
            }
            if (done && entryNum > 10000) {
                lfi.close();
                return true;
            }
            if (entryNum > 100000) {
                lfi.close();
                return false;
            }
            ++entryNum;
        }
        return true;
    }

    public boolean hasField(String filedName) {
        return this.names2index.containsKey(filedName);
    }

    protected boolean initTabix(String fileName) {
        try {
            String indexFile = fileName + ".tbi";
            if (!Gpr.exists(indexFile)) {
                throw new RuntimeException("Cannot find tabix index file '" + indexFile + "'");
            }
            if (this.verbose) {
                Log.info("Opening database file and loading index");
            }
            this.tabixReader = new TabixReader(fileName);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening tabix file '" + fileName + "'", e);
        }
        return true;
    }

    boolean isMultipleValues(String value) {
        return value.contains(SUBFIELD_SEPARATOR) || value.contains(SUBFIELD_SEPARATOR_2);
    }

    boolean loadCachedDataTypes(String cacheFileName) {
        int i2;
        if (this.verbose) {
            Log.info("Loading data types from file '" + cacheFileName + "'");
        }
        if (!Gpr.canRead(cacheFileName)) {
            if (this.verbose) {
                Log.info("Data types cache file '" + cacheFileName + "' not found");
            }
            return false;
        }
        File db = new File(this.fileName);
        File cache = new File(cacheFileName);
        if (db.lastModified() > cache.lastModified()) {
            if (this.verbose) {
                Log.info("Data types cache file '" + cacheFileName + "' needs to be updated");
            }
            return false;
        }
        String[] lines = Gpr.readFile(cacheFileName).split("\n");
        this.fieldNames = new String[lines.length];
        this.types = new VcfInfoType[lines.length];
        this.multipleValues = new boolean[lines.length];
        for (i2 = 0; i2 < lines.length; ++i2) {
            String[] fields = lines[i2].split(COLUMN_SEPARATOR);
            if (fields.length != 3) {
                throw new RuntimeException("Error parsing line " + (i2 + 1) + " from file '" + this.fileName + "':\n" + lines[i2]);
            }
            this.fieldNames[i2] = fields[0];
            this.types[i2] = fields[1].equals("null") ? null : VcfInfoType.valueOf(fields[1]);
            this.multipleValues[i2] = Gpr.parseBoolSafe(fields[2]);
        }
        this.names2index = new HashMap();
        for (i2 = 0; i2 < this.fieldNames.length; ++i2) {
            String fieldName;
            this.fieldNames[i2] = fieldName = this.fieldNames[i2].trim();
            this.names2index.put(fieldName, i2);
            this.updateIndexes(fieldName, i2);
        }
        this.updateChrPosRefAltIndex();
        return true;
    }

    protected boolean match(Variant var, DbNsfpEntry dbEntry) {
        return var.getChromosomeName().equals(dbEntry.getChromosomeName()) && var.getStart() == dbEntry.getStart() && var.getEnd() == dbEntry.getEnd() && var.getReference().equalsIgnoreCase(dbEntry.getReference()) && var.getAlt().equalsIgnoreCase(dbEntry.getAlt());
    }

    @Override
    public void open() {
        this.dataTypes();
        this.initTabix(this.fileName);
    }

    void parseHeader(String line) {
        if (!line.startsWith(HEADER_PREFIX)) {
            throw new RuntimeException("Error: Invalid header line!\n\tLine:\t" + line);
        }
        line = line.substring(HEADER_PREFIX.length());
        this.altIdx = -1;
        this.startIdx = -1;
        this.chromosomeIdx = -1;
        this.fieldNames = line.split(COLUMN_SEPARATOR, -1);
        this.types = new VcfInfoType[this.fieldNames.length];
        this.multipleValues = new boolean[this.fieldNames.length];
        this.names2index = new HashMap();
        for (int idx = 0; idx < this.fieldNames.length; ++idx) {
            String fieldName;
            this.fieldNames[idx] = fieldName = this.fieldNames[idx].trim();
            this.names2index.put(fieldName, idx);
            this.updateIndexes(fieldName, idx);
        }
        if (this.chromosomeIdx == -1) {
            throw new RuntimeException("Missing 'chr' columns in dbNSFP file");
        }
        if (this.startIdx == -1) {
            throw new RuntimeException("Missing 'pos(1-coor)' columns in dbNSFP file");
        }
        if (this.altIdx == -1) {
            throw new RuntimeException("Missing 'alt' columns in dbNSFP file");
        }
        this.updateChrPosRefAltIndex();
    }

    void updateChrPosRefAltIndex() {
        this.maxChrPosRefAltIdx = -1;
        this.maxChrPosRefAltIdx = Math.max(this.maxChrPosRefAltIdx, this.chromosomeIdx);
        this.maxChrPosRefAltIdx = Math.max(this.maxChrPosRefAltIdx, this.startIdx);
        this.maxChrPosRefAltIdx = Math.max(this.maxChrPosRefAltIdx, this.refIdx);
        this.maxChrPosRefAltIdx = Math.max(this.maxChrPosRefAltIdx, this.altIdx);
    }

    @Override
    public Collection<DbNsfpEntry> query(Variant variant) {
        LinkedList<DbNsfpEntry> results = new LinkedList<DbNsfpEntry>();
        if (this.latestResultsInterval.includes(variant)) {
            for (DbNsfpEntry de : this.latestResults) {
                if (!this.match(variant, de)) continue;
                results.add(de);
            }
            return results;
        }
        TabixReader.Iterator tabixIterator = this.tabixReader.query(variant.getChromosomeName(), variant.getStart(), variant.getEnd() + 1);
        this.latestResults = new LinkedList<DbNsfpEntry>();
        this.latestResultsInterval = variant;
        if (tabixIterator == null) {
            return null;
        }
        int numLines = 0;
        try {
            String line;
            while ((line = tabixIterator.next()) != null) {
                DbNsfpEntry de;
                line = Gpr.removeBackslashR(line);
                if (this.debug) {
                    Log.debug("Query: Parse line " + line);
                }
                if (this.match(variant, de = new DbNsfpEntry(this, line))) {
                    results.add(de);
                }
                this.latestResults.add(de);
                ++numLines;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading tabix file '" + this.fileName + "'", e);
        }
        if (this.debug) {
            Log.debug("Query: " + variant.toStr() + "\tParsed lines: " + numLines);
        }
        return results;
    }

    protected void saveDataTypesCache(String cacheFileName) {
        if (this.verbose) {
            Log.info("Saving data types to file '" + cacheFileName + "'");
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.fieldNames.length; ++i2) {
            sb.append(this.fieldNames[i2]).append(COLUMN_SEPARATOR).append((Object)this.types[i2]).append(COLUMN_SEPARATOR).append(this.multipleValues[i2]).append("\n");
        }
        Gpr.toFile(cacheFileName, sb);
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    void updateIndexes(String fieldName, int idx) {
        switch (fieldName.toLowerCase()) {
            case "chr": {
                this.chromosomeIdx = idx;
                break;
            }
            case "pos(1-coor)": 
            case "pos(1-based)": {
                this.startIdx = idx;
                break;
            }
            case "alt": {
                this.altIdx = idx;
                break;
            }
            case "ref": {
                this.refIdx = idx;
                break;
            }
        }
    }
}

