/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.caseControl;

import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;

public class VariantCounter {
    int[] genotypes;
    StringBuilder effects;

    public VariantCounter(int size) {
        this.genotypes = new int[size];
        this.effects = new StringBuilder();
    }

    public void addEffect(String effStr) {
        if (this.effects.length() > 0) {
            this.effects.append("\t");
        }
        this.effects.append(effStr);
    }

    public int countNonZeroGenotypes() {
        int count = 0;
        for (int i2 = 0; i2 < this.genotypes.length; ++i2) {
            if (this.genotypes[i2] <= 0) continue;
            ++count;
        }
        return count;
    }

    public int getGenotype(int idx) {
        return this.genotypes[idx];
    }

    public void incGenotype(int idx) {
        int n = idx;
        this.genotypes[n] = this.genotypes[n] + 1;
    }

    public void incGenotype(int idx, int value) {
        int n = idx;
        this.genotypes[n] = this.genotypes[n] + value;
    }

    public void parseGenotypes(VcfEntry ve) {
        int idx = 0;
        for (VcfGenotype gen : ve.getVcfGenotypes()) {
            if (gen.isVariant()) {
                int n = idx;
                this.genotypes[n] = this.genotypes[n] + 1;
            }
            ++idx;
        }
    }

    public void setGenotype(int idx, int value) {
        this.genotypes[idx] = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.countNonZeroGenotypes());
        for (int i2 = 0; i2 < this.genotypes.length; ++i2) {
            sb.append("\t" + this.genotypes[i2]);
        }
        sb.append("\t");
        sb.append((CharSequence)this.effects);
        return sb.toString();
    }
}

