/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.variantTypeCounter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.annotate.mem.Fields;
import org.snpsift.annotate.mem.variantTypeCounter.VariantTypeCounter;
import org.snpsift.util.ShowProgress;

public class VariantTypeCounters {
    Fields fields;
    Map<String, VariantTypeCounter> counters = new HashMap<String, VariantTypeCounter>();
    String latestChr = "";
    VariantTypeCounter latestCounter = null;
    VariantTypeCounter counterAll;
    int count = 0;
    boolean verbose = false;

    public VariantTypeCounters(boolean verbose) {
        this.verbose = verbose;
        this.fields = new Fields();
        this.counterAll = new VariantTypeCounter(this.fields);
    }

    public VariantTypeCounters(Fields fields, boolean verbose) {
        this.fields = fields;
        this.verbose = verbose;
        this.counterAll = new VariantTypeCounter(fields);
    }

    public static VariantTypeCounters load(String fileName) {
        try {
            File file = new File(fileName);
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            VariantTypeCounters vc = (VariantTypeCounters)ois.readObject();
            ois.close();
            return vc;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load from file '" + fileName + "'", e);
        }
    }

    public void count(String vcfFileName) {
        if (this.verbose) {
            Log.info("Counting number of variants in '" + vcfFileName + "'");
        }
        this.count(new VcfFileIterator(vcfFileName));
    }

    public void count(VcfFileIterator vcfFile) {
        ShowProgress progress = new ShowProgress();
        int i2 = 0;
        for (VcfEntry vcfEntry : vcfFile) {
            this.count(vcfEntry);
            progress.tick(++i2, vcfEntry);
        }
        vcfFile.close();
        if (this.verbose) {
            Log.info("\nDone, " + i2 + " VCF entries in " + progress.elapsedSec() + " secs\n");
        }
    }

    public void count(VcfEntry vcfEntry) {
        String chr = vcfEntry.getChromosomeName();
        if (!chr.equals(this.latestChr) || this.latestCounter == null) {
            this.latestChr = chr;
            this.latestCounter = this.counters.get(chr);
            if (this.latestCounter == null) {
                this.latestCounter = new VariantTypeCounter(this.fields);
                this.counters.put(chr, this.latestCounter);
            }
        }
        this.latestCounter.count(vcfEntry);
        this.counterAll.count(vcfEntry);
        ++this.count;
    }

    public VariantTypeCounter get(String chr) {
        return this.counters.get(chr);
    }

    public Fields getFields() {
        return this.fields;
    }

    public void save(String fileName) {
        try {
            File file = new File(fileName);
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot save to file '" + fileName + "'", e);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Total variants: " + this.count + "\n");
        sb.append(this.counterAll.toString());
        for (String chr : this.counters.keySet()) {
            sb.append("Chromosome: " + chr + "\n");
            sb.append(this.counters.get(chr).toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

