/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.variantTypeCounter;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Variant;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeader;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;
import org.snpsift.annotate.mem.Fields;
import org.snpsift.annotate.mem.VariantCategory;

public class VariantTypeCounter
implements Serializable {
    private static final long serialVersionUID = 2024073102L;
    public static final String REF = "REF";
    public static final String ALT = "ALT";
    protected Fields fields;
    protected String[] fieldsString;
    protected int[] countByCategory;
    protected long countVcfEntries = 0L;
    protected long countVariants = 0L;
    protected Map<String, int[]> sizesByField;

    public static VariantTypeCounter countVariants(String vcfLines) {
        VcfHeader vcfHeader = VcfFileIterator.fromString(vcfLines).readHeader();
        Fields fields = new Fields();
        for (VcfHeaderInfo vi : vcfHeader.getVcfHeaderInfo()) {
            if (vi.isImplicit() && !Fields.VCF_COLUMN_FIELD_NAMES.contains(vi.getId())) continue;
            fields.add(vi);
        }
        VariantTypeCounter variantTypeCounter = new VariantTypeCounter(fields);
        for (VcfEntry vcfEntry : VcfFileIterator.fromString(vcfLines)) {
            variantTypeCounter.count(vcfEntry);
        }
        return variantTypeCounter;
    }

    public VariantTypeCounter(Fields fields) {
        this.fields = fields;
        ArrayList<String> fieldsStringList = new ArrayList<String>();
        for (String field : fields.getNames()) {
            if (fields.get(field).getVcfInfoType() != VcfInfoType.String) continue;
            fieldsStringList.add(field);
        }
        this.fieldsString = fieldsStringList.toArray(new String[0]);
        int numberOfCategories = VariantCategory.size();
        this.countByCategory = new int[numberOfCategories];
        this.sizesByField = new HashMap<String, int[]>();
        for (String field : this.fieldsString) {
            this.sizesByField.put(field, new int[numberOfCategories]);
        }
        this.sizesByField.put(REF, new int[numberOfCategories]);
        this.sizesByField.put(ALT, new int[numberOfCategories]);
    }

    public void count(VcfEntry vcfEntry) {
        ++this.countVcfEntries;
        for (Variant variant : vcfEntry.variants()) {
            int variantCategoryOrd;
            ++this.countVariants;
            VariantCategory variantCategory = VariantCategory.of(variant);
            int n = variantCategoryOrd = variantCategory.ordinal();
            this.countByCategory[n] = this.countByCategory[n] + 1;
            for (String fieldName : this.fieldsString) {
                String fieldValue = Fields.getFieldValueString(fieldName, vcfEntry);
                this.updateSizes(variantCategory, fieldName, fieldValue);
            }
            this.updateSizes(variantCategory, REF, variant.getReference());
            this.updateSizes(variantCategory, ALT, variant.getAlt());
        }
    }

    public int getCount(VariantCategory variantCategory) {
        return this.countByCategory[variantCategory.ordinal()];
    }

    public int[] getCountByCategory() {
        return this.countByCategory;
    }

    public Fields getFields() {
        return this.fields;
    }

    public int getSize(VariantCategory variantCategory, String field) {
        int[] sizes = this.sizesByField.get(field);
        if (sizes == null) {
            return -1;
        }
        return sizes[variantCategory.ordinal()];
    }

    public Map<String, int[]> getSizesByField() {
        return this.sizesByField;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("VariantTypeCounter:");
        sb.append("VCF entries: " + this.countVcfEntries);
        sb.append(", Variants: " + this.countVariants + "\n");
        for (VariantCategory variantCategory : VariantCategory.values()) {
            int variantCategoryOrd = variantCategory.ordinal();
            sb.append("\t" + String.valueOf((Object)variantCategory) + ": " + this.countByCategory[variantCategoryOrd] + ". ");
            for (String field : this.fieldsString) {
                sb.append(field + ": " + this.sizesByField.get(field)[variantCategoryOrd] + ", ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected void updateSizes(VariantCategory variantCategory, String field, String value) {
        if (value == null) {
            return;
        }
        int[] sizes = this.sizesByField.get(field);
        byte[] utf8Bytes = value.getBytes(StandardCharsets.UTF_8);
        int n = variantCategory.ordinal();
        sizes[n] = sizes[n] + utf8Bytes.length;
    }
}

