/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.database;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Marker;
import org.snpeff.util.Log;
import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeader;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpsift.annotate.mem.Fields;
import org.snpsift.annotate.mem.SortedVariantsVcfIterator;
import org.snpsift.annotate.mem.database.VariantDataFrame;
import org.snpsift.annotate.mem.variantTypeCounter.VariantTypeCounter;
import org.snpsift.annotate.mem.variantTypeCounter.VariantTypeCounters;
import org.snpsift.util.ShowProgress;

public class VariantDatabase {
    public static final String VARIANT_DATABASE_EXT = "snpsift.vardb";
    public static final String VARIANT_DATAFRAME_EXT = "snpsift.df";
    public static final String FIELDS_EXT = "snpsift.db_fields";
    String chr = null;
    Marker currentInterval = null;
    String databaseVcfFileName;
    String dbDir = null;
    boolean emptyIfNotFound;
    Fields fields = null;
    String[] fieldNamesAnnotate = null;
    String[] fieldNamesCreate = null;
    String prefix;
    VariantDataFrame variantDataFrame = null;
    VariantTypeCounters variantTypeCounters = null;
    boolean verbose = false;

    public static String dbDirFromVcfFileName(String dbFileName) {
        return dbFileName + ".snpsift.vardb";
    }

    public VariantDatabase() {
    }

    public VariantDatabase(String databaseVcfFileName, String dbDir, String[] fieldNamesCreate) {
        this();
        this.databaseVcfFileName = databaseVcfFileName;
        this.dbDir = dbDir;
        this.fieldNamesCreate = fieldNamesCreate;
    }

    public VariantDatabase(String databaseVcfFileName, String dbDir, String[] fieldNamesAnnotate, String prefix, boolean emptyIfNotFound) {
        this();
        this.databaseVcfFileName = databaseVcfFileName;
        this.dbDir = dbDir;
        this.fieldNamesAnnotate = fieldNamesAnnotate;
        this.prefix = prefix;
        this.emptyIfNotFound = emptyIfNotFound;
    }

    protected void add(VariantVcfEntry variantVcfEntry) {
        String chr = variantVcfEntry.getChromosomeName();
        if (!chr.equals(this.chr)) {
            this.saveCurrentDataFrame();
            this.chr = chr;
            VariantTypeCounter vcounter = this.variantTypeCounters.get(chr);
            if (vcounter == null) {
                throw new RuntimeException("Cannot find variant type counters for chromosome: '" + chr + "'");
            }
            this.variantDataFrame = new VariantDataFrame(vcounter);
        }
        this.variantDataFrame.add(variantVcfEntry);
    }

    public int annotate(VcfEntry vcfEntry) {
        String chr = vcfEntry.getChromosomeName();
        VariantDataFrame df = this.get(chr);
        return df.annotate(vcfEntry, this.fieldNamesAnnotate);
    }

    public boolean checkFields(String[] fieldNames, boolean throwExceptionOnError) {
        for (String fieldName : fieldNames) {
            if (this.fields.get(fieldName) != null) continue;
            if (throwExceptionOnError) {
                throw new RuntimeException("Field '" + fieldName + "' not found in database.");
            }
            return false;
        }
        return true;
    }

    public void create(String vcfContents) {
        this.fields = this.parseVcfHeaderFields(VcfFileIterator.fromString(vcfContents));
        this.checkFields(this.fieldNamesCreate, true);
        this.variantTypeCounters = new VariantTypeCounters(this.fields, this.verbose);
        this.variantTypeCounters.count(VcfFileIterator.fromString(vcfContents));
        SortedVariantsVcfIterator sortedVariants = SortedVariantsVcfIterator.lines2SortedVariantsVcfIterator(vcfContents);
        this.createFromVcf(sortedVariants);
        sortedVariants.close();
    }

    public void create() {
        File dir = new File(this.dbDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.fields = this.parseVcfHeaderFields(this.databaseVcfFileName);
        this.checkFields(this.fieldNamesCreate, true);
        this.variantTypeCounters = new VariantTypeCounters(this.fields, this.verbose);
        this.variantTypeCounters.count(this.databaseVcfFileName);
        if (this.verbose) {
            Log.info("Creating variant database from VCF file '" + this.databaseVcfFileName + "'");
        }
        SortedVariantsVcfIterator sortedVariants = new SortedVariantsVcfIterator(this.databaseVcfFileName);
        this.createFromVcf(sortedVariants);
        sortedVariants.close();
        this.saveCurrentDataFrame();
        this.saveFields();
    }

    void createFromVcf(SortedVariantsVcfIterator sortedVariants) {
        int i2 = 0;
        ShowProgress progress = new ShowProgress();
        for (VariantVcfEntry variantVcf : sortedVariants) {
            this.add(variantVcf);
            progress.tick(++i2, variantVcf);
        }
        if (this.verbose) {
            Log.info("\nDone: " + i2 + " variants in " + progress.elapsedSec() + " seconds.");
        }
    }

    public VariantDataFrame get(String chr) {
        if (chr.equals(this.chr)) {
            return this.variantDataFrame;
        }
        this.chr = chr;
        String variantDataFrameFile = this.dbDir + "/" + chr + ".snpsift.df";
        if (this.verbose) {
            Log.info("Loading data frame from file: " + variantDataFrameFile);
        }
        this.variantDataFrame = VariantDataFrame.load(chr, variantDataFrameFile, this.emptyIfNotFound);
        this.variantDataFrame.setPrefix(this.prefix);
        return this.variantDataFrame;
    }

    public String getDatabaseVcfFileName() {
        return this.databaseVcfFileName;
    }

    public String getDbDir() {
        return this.dbDir;
    }

    public Fields getFields() {
        return this.fields;
    }

    public VariantTypeCounters getVariantTypeCounters() {
        return this.variantTypeCounters;
    }

    public void load() {
        this.fields = Fields.load(this.dbDir + "/fields.snpsift.db_fields");
    }

    protected Fields parseVcfHeaderFields(String databaseVcfFileName) {
        VcfFileIterator vcfFile = new VcfFileIterator(databaseVcfFileName);
        return this.parseVcfHeaderFields(vcfFile);
    }

    protected Fields parseVcfHeaderFields(VcfFileIterator vcfFileIterator) {
        Fields fields = new Fields();
        List<String> fnames = Arrays.asList(this.fieldNamesCreate);
        HashSet<String> fieldNamesSet = new HashSet<String>(fnames);
        VcfHeader vcfHeader = vcfFileIterator.readHeader();
        for (VcfHeaderInfo vcfInfo : vcfHeader.getVcfHeaderInfo()) {
            if (vcfInfo.isImplicit() && !Fields.VCF_COLUMN_FIELD_NAMES.contains(vcfInfo.getId()) || !fieldNamesSet.contains(vcfInfo.getId())) continue;
            fields.add(vcfInfo);
        }
        vcfFileIterator.close();
        return fields;
    }

    public void saveFields() {
        new File(this.dbDir).mkdirs();
        this.fields.save(this.dbDir + "/fields.snpsift.db_fields");
    }

    public String saveCurrentDataFrame() {
        if (this.variantDataFrame != null) {
            File dir = new File(this.dbDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = this.dbDir + "/" + this.chr + ".snpsift.df";
            this.variantDataFrame.save(fileName);
            return fileName;
        }
        return null;
    }

    public void setDbDir(String dbDir) {
        this.dbDir = dbDir;
    }

    public void setFieldNamesAnnotate(String[] fieldNamesAnnotate) {
        this.fieldNamesAnnotate = fieldNamesAnnotate;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        if (this.variantDataFrame != null) {
            this.variantDataFrame.setPrefix(prefix);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VariantDatabase[chr: " + this.chr + "]\n");
        sb.append(this.variantDataFrame);
        return sb.toString();
    }

    public Collection<VcfHeaderEntry> vcfHeaders() {
        return this.fields.vcfHeaders(this.prefix);
    }
}

