/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.snpeff.interval.Variant;
import org.snpeff.util.Log;
import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpsift.annotate.mem.Fields;
import org.snpsift.annotate.mem.VariantCategory;
import org.snpsift.annotate.mem.dataFrame.DataFrame;
import org.snpsift.annotate.mem.dataFrame.DataFrameDel;
import org.snpsift.annotate.mem.dataFrame.DataFrameIns;
import org.snpsift.annotate.mem.dataFrame.DataFrameMixed;
import org.snpsift.annotate.mem.dataFrame.DataFrameMnp;
import org.snpsift.annotate.mem.dataFrame.DataFrameOther;
import org.snpsift.annotate.mem.dataFrame.DataFrameRow;
import org.snpsift.annotate.mem.dataFrame.DataFrameSnp;
import org.snpsift.annotate.mem.variantTypeCounter.VariantTypeCounter;
import org.snpsift.util.FormatUtil;

public class VariantDataFrame
implements Serializable {
    private static final long serialVersionUID = 2024092701L;
    Fields fields;
    DataFrame[] dataFrames;
    String prefix;
    VariantTypeCounter variantTypeCounter;

    public static VariantDataFrame load(String chr, String fileName, boolean emptyIfNotFound) {
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                if (emptyIfNotFound) {
                    Log.warning("File not found for chromosome '" + chr + "', file '" + fileName + "'");
                    return new VariantDataFrame(new VariantTypeCounter(new Fields()));
                }
                throw new RuntimeException("File not found for chromosome '" + chr + "', '" + fileName + "'");
            }
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            VariantDataFrame vd = (VariantDataFrame)ois.readObject();
            ois.close();
            return vd;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load file for chromosome '" + chr + "', file '" + fileName + "'", e);
        }
    }

    public VariantDataFrame(VariantTypeCounter variantTypeCounter) {
        this.variantTypeCounter = variantTypeCounter;
        this.fields = variantTypeCounter.getFields();
        this.dataFrames = new DataFrame[VariantCategory.size()];
        this.dataFrames[VariantCategory.SNP_A.ordinal()] = new DataFrameSnp(variantTypeCounter, VariantCategory.SNP_A);
        this.dataFrames[VariantCategory.SNP_C.ordinal()] = new DataFrameSnp(variantTypeCounter, VariantCategory.SNP_C);
        this.dataFrames[VariantCategory.SNP_G.ordinal()] = new DataFrameSnp(variantTypeCounter, VariantCategory.SNP_G);
        this.dataFrames[VariantCategory.SNP_T.ordinal()] = new DataFrameSnp(variantTypeCounter, VariantCategory.SNP_T);
        this.dataFrames[VariantCategory.INS.ordinal()] = new DataFrameIns(variantTypeCounter, VariantCategory.INS);
        this.dataFrames[VariantCategory.DEL.ordinal()] = new DataFrameDel(variantTypeCounter, VariantCategory.DEL);
        this.dataFrames[VariantCategory.MNP.ordinal()] = new DataFrameMnp(variantTypeCounter, VariantCategory.MNP);
        this.dataFrames[VariantCategory.MIXED.ordinal()] = new DataFrameMixed(variantTypeCounter, VariantCategory.MIXED);
        this.dataFrames[VariantCategory.OTHER.ordinal()] = new DataFrameOther(variantTypeCounter, VariantCategory.OTHER);
    }

    void add(VariantVcfEntry variantVcfEntry) {
        DataFrame dataFrame = this.getDataFrameByVariantType(variantVcfEntry);
        if (dataFrame == null) {
            throw new RuntimeException("Cannot find data frame for variant: " + variantVcfEntry.toString());
        }
        DataFrameRow row = new DataFrameRow(dataFrame, variantVcfEntry.getStart(), variantVcfEntry.getReference(), variantVcfEntry.getAlt());
        for (VcfHeaderInfo field : this.fields) {
            Object value = Fields.getFieldValue(field, variantVcfEntry);
            row.set(field.getId(), value);
        }
        try {
            dataFrame.add(row);
        }
        catch (Exception e) {
            throw new RuntimeException("Error adding row to dataFrame:\n\trow: " + String.valueOf(row) + "\n\tvariant category: " + String.valueOf((Object)VariantCategory.of(variantVcfEntry)) + "\n\t" + String.valueOf(variantVcfEntry), e);
        }
    }

    public int annotate(VcfEntry vcfEntry, String[] fieldNames) {
        int found = 0;
        for (Variant variant : vcfEntry.variants()) {
            DataFrame dataFrame = this.getDataFrameByVariantType(variant);
            if (dataFrame == null) {
                throw new RuntimeException("Cannot find data set for variant: " + variant.toString());
            }
            DataFrameRow row = dataFrame.getRow(variant.getStart(), variant.getReference(), variant.getAlt());
            if (row == null) continue;
            if (fieldNames != null) {
                for (String field : fieldNames) {
                    Object value = row.getDataFrameValue(field);
                    if (value == null) continue;
                    String outFieldName = this.prefix != null ? this.prefix + (String)field : field;
                    vcfEntry.addInfo(outFieldName, value.toString());
                    ++found;
                }
                continue;
            }
            for (String field : row) {
                Object value = row.getDataFrameValue(field);
                if (value == null) continue;
                String outFieldName = this.prefix != null ? this.prefix + field : field;
                vcfEntry.addInfo(outFieldName, value.toString());
                ++found;
            }
        }
        return found;
    }

    public void check() {
        for (DataFrame dataFrame : this.dataFrames) {
            dataFrame.check();
        }
    }

    public DataFrame getDataFrameByVariantType(Variant variant) {
        return this.getDataFrameByCategory(VariantCategory.of(variant));
    }

    public DataFrame getDataFrameByCategory(VariantCategory category) {
        return this.dataFrames[category.ordinal()];
    }

    void resize() {
        for (DataFrame dataFrame : this.dataFrames) {
            dataFrame.resize();
        }
    }

    void save(String fileName) {
        this.check();
        this.resize();
        try {
            Log.info("Saving to file '" + fileName + "'");
            File file = new File(fileName);
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot save to file '" + fileName + "'", e);
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public long sizeBytes() {
        long size = 0L;
        for (DataFrame dataFrame : this.dataFrames) {
            size += dataFrame.sizeBytes();
        }
        return size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VariantDataFrame: memory= " + FormatUtil.formatBytes(this.sizeBytes()) + "\n");
        for (VariantCategory vc : VariantCategory.values()) {
            sb.append("Variant category: " + String.valueOf((Object)vc) + "\n");
            sb.append(String.valueOf(this.dataFrames[vc.ordinal()]) + "\n");
        }
        return sb.toString();
    }
}

