/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.dataFrame.dataFrameColumn;

import java.util.HashSet;
import org.snpsift.annotate.mem.arrays.EnumArray;
import org.snpsift.annotate.mem.arrays.StringArray;
import org.snpsift.annotate.mem.arrays.StringArrayBase;
import org.snpsift.annotate.mem.dataFrame.dataFrameColumn.DataFrameColumn;

public class DataFrameColumnString
extends DataFrameColumn<String> {
    private static final long serialVersionUID = 202407310306L;
    StringArrayBase data;

    public static DataFrameColumnString of(String name, String[] strings) {
        int size = StringArray.sizeOf(strings);
        DataFrameColumnString col = new DataFrameColumnString(name, strings.length, size);
        for (int i2 = 0; i2 < strings.length; ++i2) {
            col.set(i2, strings[i2]);
        }
        return col;
    }

    public DataFrameColumnString(String name, int length, int size) {
        super(name, length);
        this.data = new StringArray(length, size);
    }

    @Override
    protected String getData(int i2) {
        return this.data.get(i2);
    }

    public StringArrayBase getData() {
        return this.data;
    }

    @Override
    public void resize() {
        HashSet<String> set = new HashSet<String>();
        boolean useEnumArray = true;
        for (int i2 = 0; i2 < this.data.length(); ++i2) {
            if (!set.add(this.data.get(i2)) || set.size() <= 255) continue;
            useEnumArray = false;
            break;
        }
        if (useEnumArray) {
            EnumArray ea = new EnumArray(this.data.size());
            for (String str : this.data) {
                ea.add(str);
            }
            this.data = ea;
        }
    }

    @Override
    protected void setData(int i2, Object value) {
        this.data.set(i2, value.toString());
    }

    @Override
    public int size() {
        return this.data.length();
    }

    @Override
    public long sizeBytes() {
        return (long)this.isNUllData.sizeBytes() + this.data.sizeBytes();
    }
}

