/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.dataFrame.dataFrameColumn;

import java.io.Serializable;
import org.snpsift.annotate.mem.arrays.BoolArray;

public abstract class DataFrameColumn<T>
implements Serializable {
    private static final long serialVersionUID = 2024073103L;
    public static final int MAX_NUMBER_OF_ELEMENTS_TO_SHOW = 10;
    protected String name;
    protected BoolArray isNUllData;

    public DataFrameColumn(String name, int size) {
        this.name = name;
        this.isNUllData = new BoolArray(size);
        this.isNUllData.fill();
    }

    public void check() {
    }

    public String getName() {
        return this.name;
    }

    public boolean isNull(int i2) {
        return this.isNUllData.is(i2);
    }

    public T get(int i2) {
        if (this.isNull(i2)) {
            return null;
        }
        return this.getData(i2);
    }

    protected abstract T getData(int var1);

    public void resize() {
    }

    public void set(int i2, Object value) {
        if (value == null) {
            this.isNUllData.set(i2);
        } else {
            this.isNUllData.clear(i2);
            this.setData(i2, value);
        }
    }

    protected abstract void setData(int var1, Object var2);

    public abstract int size();

    public abstract long sizeBytes();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName() + ": '" + this.name + "', size: " + this.size() + "\n");
        for (int i2 = 0; i2 < this.size() && i2 < 10; ++i2) {
            sb.append("\t" + i2 + ": " + (this.isNull(i2) ? "null" : this.get(i2).toString()) + "\n");
        }
        return sb.toString();
    }
}

