/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.dataFrame;

import org.snpsift.annotate.mem.VariantCategory;
import org.snpsift.annotate.mem.dataFrame.DataFrame;
import org.snpsift.annotate.mem.variantTypeCounter.VariantTypeCounter;

public class DataFrameSnp
extends DataFrame {
    private static final long serialVersionUID = 2024073109L;
    String alt;

    public DataFrameSnp(VariantTypeCounter variantTypeCounter, VariantCategory variantCategory) {
        super(variantTypeCounter, variantCategory, false, false);
        switch (variantCategory) {
            case SNP_A: {
                this.alt = "A";
                break;
            }
            case SNP_C: {
                this.alt = "C";
                break;
            }
            case SNP_G: {
                this.alt = "G";
                break;
            }
            case SNP_T: {
                this.alt = "T";
                break;
            }
            default: {
                throw new RuntimeException("Cannot create DataFrameSnp for variant category: " + String.valueOf((Object)variantCategory));
            }
        }
    }

    public String getAlt() {
        return this.alt;
    }

    @Override
    protected boolean eq(int idx, int pos, String ref, String alt) {
        if (this.posIndex.get(idx) != pos) {
            return false;
        }
        if (!this.alt.equals(alt.toUpperCase())) {
            throw new RuntimeException("This should never happen! Alt: " + alt + " != " + this.alt);
        }
        return true;
    }
}

