/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.dataFrame;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.snpsift.annotate.mem.dataFrame.DataFrame;

public class DataFrameRow
implements Serializable,
Iterable<String> {
    private static final long serialVersionUID = 2024073108L;
    DataFrame dataFrame;
    int pos;
    String ref;
    String alt;
    int idx;
    Map<String, Object> values;

    public DataFrameRow(DataFrame dataFrame, int pos, String ref, String alt) {
        this(dataFrame, pos, ref, alt, -1);
    }

    public DataFrameRow(DataFrame dataFrame, int pos, String ref, String alt, int idx) {
        this.dataFrame = dataFrame;
        this.pos = pos;
        this.ref = ref;
        this.alt = alt;
        this.idx = idx;
    }

    public Map<String, Object> getDataFrameValues() {
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
            for (String col : this) {
                this.values.put(col, this.getDataFrameValue(col));
            }
        }
        return this.values;
    }

    public Object get(String columnName) {
        return this.values.get(columnName);
    }

    public Object getDataFrameValue(String columnName) {
        return this.dataFrame.get(columnName, this.idx);
    }

    public String getAlt() {
        return this.alt;
    }

    public int getIdx() {
        return this.idx;
    }

    public int getPos() {
        return this.pos;
    }

    public String getRef() {
        return this.ref;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    @Override
    public Iterator<String> iterator() {
        return this.dataFrame.columnNames().iterator();
    }

    public void set(String columnName, Object value) {
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        this.values.put(columnName, value);
    }

    public void setDataFrame(String columnName) {
        this.dataFrame.set(columnName, this.idx, this.get(columnName));
    }

    public void setDataFrame(String columnName, Object value) {
        this.dataFrame.set(columnName, this.idx, value);
    }

    public void setDataFrame() {
        for (String col : this) {
            this.setDataFrame(col, this.values.get(col));
        }
    }

    protected void setIdx(int idx) {
        this.idx = idx;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataFrameRow: pos=" + this.pos + ", ref=" + this.ref + ", alt=" + this.alt + ", idx=" + this.idx);
        if (this.values != null) {
            for (String col : this) {
                sb.append(", " + col + "='" + String.valueOf(this.get(col)) + "'");
            }
        }
        return sb.toString();
    }
}

