/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.dataFrame;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpsift.annotate.mem.Fields;
import org.snpsift.annotate.mem.VariantCategory;
import org.snpsift.annotate.mem.arrays.PosIndex;
import org.snpsift.annotate.mem.arrays.StringArray;
import org.snpsift.annotate.mem.dataFrame.DataFrameRow;
import org.snpsift.annotate.mem.dataFrame.dataFrameColumn.DataFrameColumn;
import org.snpsift.annotate.mem.dataFrame.dataFrameColumn.DataFrameColumnBool;
import org.snpsift.annotate.mem.dataFrame.dataFrameColumn.DataFrameColumnChar;
import org.snpsift.annotate.mem.dataFrame.dataFrameColumn.DataFrameColumnDouble;
import org.snpsift.annotate.mem.dataFrame.dataFrameColumn.DataFrameColumnInt;
import org.snpsift.annotate.mem.dataFrame.dataFrameColumn.DataFrameColumnString;
import org.snpsift.annotate.mem.variantTypeCounter.VariantTypeCounter;
import org.snpsift.util.FormatUtil;

public class DataFrame
implements Serializable {
    private static final long serialVersionUID = 2024073101L;
    public static final int MAX_ROWS_TO_SHOW = 100;
    VariantTypeCounter variantTypeCounter;
    VariantCategory variantCategory;
    int currentIdx = 0;
    PosIndex posIndex;
    StringArray refs;
    StringArray alts;
    Map<String, DataFrameColumn<?>> columns;
    Fields fields;

    public DataFrame(VariantTypeCounter variantTypeCounter, VariantCategory variantCategory, boolean hasRefs, boolean hasAlts) {
        this.variantTypeCounter = variantTypeCounter;
        this.variantCategory = variantCategory;
        int size = variantTypeCounter.getCount(variantCategory);
        this.posIndex = new PosIndex(size);
        this.columns = new HashMap();
        this.fields = variantTypeCounter.getFields();
        this.createColumns();
        if (hasRefs) {
            this.refs = new StringArray(size, this.stringArrayMemSize(variantCategory, "REF"));
        }
        if (hasAlts) {
            this.alts = new StringArray(size, this.stringArrayMemSize(variantCategory, "ALT"));
        }
    }

    void add(String name, DataFrameColumn<?> column) {
        this.columns.put(name, column);
    }

    public void add(DataFrameRow row) {
        if (row.getIdx() >= 0) {
            throw new RuntimeException("Row already added");
        }
        this.posIndex.set(this.currentIdx, row.getPos());
        row.setIdx(this.currentIdx);
        if (this.refs != null) {
            this.refs.set(this.currentIdx, row.getRef());
        }
        if (this.alts != null) {
            this.alts.set(this.currentIdx, row.getAlt());
        }
        row.setDataFrame();
        ++this.currentIdx;
    }

    public void check() {
        this.posIndex.check();
        for (DataFrameColumn<?> col : this.columns.values()) {
            col.check();
        }
    }

    public Iterable<String> columnNames() {
        return this.columns.keySet();
    }

    protected DataFrameColumn<?> createColumn(VcfHeaderInfo vcfHeaderInfo) {
        int numEntries = this.variantTypeCounter.getCount(this.variantCategory);
        String fieldName = vcfHeaderInfo.getId();
        switch (vcfHeaderInfo.getVcfInfoType()) {
            case Flag: {
                return new DataFrameColumnBool(fieldName, numEntries);
            }
            case Integer: {
                return new DataFrameColumnInt(fieldName, numEntries);
            }
            case Float: {
                return new DataFrameColumnDouble(fieldName, numEntries);
            }
            case Character: {
                return new DataFrameColumnChar(fieldName, numEntries);
            }
            case String: {
                int memSize = this.stringArrayMemSize(this.variantCategory, fieldName);
                return new DataFrameColumnString(fieldName, numEntries, memSize);
            }
        }
        throw new RuntimeException("Unimplemented type: " + String.valueOf((Object)vcfHeaderInfo.getVcfInfoType()));
    }

    protected void createColumns() {
        for (VcfHeaderInfo field : this.fields) {
            DataFrameColumn<?> column = this.createColumn(field);
            this.add(field.getId(), column);
        }
    }

    protected boolean eq(int idx, int pos, String ref, String alt) {
        if (this.posIndex.get(idx) != pos) {
            return false;
        }
        if (ref != null && this.refs != null && !this.refs.get(idx).equals(ref)) {
            return false;
        }
        return alt == null || this.alts == null || this.alts.get(idx).equals(alt);
    }

    protected Object get(String columnName, int idx) {
        DataFrameColumn<?> col = this.columns.get(columnName);
        return col.get(idx);
    }

    public DataFrameColumn<?> getColumn(String name) {
        return this.columns.get(name);
    }

    public DataFrameRow getRow(int pos, String ref, String alt) {
        int idx = this.find(pos, ref, alt);
        if (idx < 0) {
            return null;
        }
        return new DataFrameRow(this, pos, ref, alt, idx);
    }

    protected int find(int pos, String ref, String alt) {
        int i2;
        int idx = this.posIndex.indexOf(pos);
        if (idx < 0) {
            return -1;
        }
        if (this.eq(idx, pos, ref, alt)) {
            return idx;
        }
        for (i2 = idx - 1; i2 >= 0 && this.posIndex.get(i2) == pos; --i2) {
            if (!this.eq(i2, pos, ref, alt)) continue;
            return i2;
        }
        for (i2 = idx + 1; i2 < this.posIndex.size(); ++i2) {
            if (this.posIndex.get(i2) != pos) {
                return -1;
            }
            if (!this.eq(i2, pos, ref, alt)) continue;
            return i2;
        }
        return -1;
    }

    public boolean hasEntry(int pos, String ref, String alt) {
        return this.find(pos, ref, alt) >= 0;
    }

    public void resize() {
        for (DataFrameColumn<?> col : this.columns.values()) {
            col.resize();
        }
    }

    protected void set(String columnName, int idx, Object value) {
        this.columns.get(columnName).set(idx, value);
    }

    public long sizeBytes() {
        long size = this.posIndex.sizeBytes();
        for (DataFrameColumn<?> col : this.columns.values()) {
            size += col.sizeBytes();
        }
        if (this.refs != null) {
            size += this.refs.sizeBytes();
        }
        if (this.alts != null) {
            size += this.alts.sizeBytes();
        }
        return size;
    }

    int stringArrayMemSize(VariantCategory variantCategory, String field) {
        int size = this.variantTypeCounter.getSize(variantCategory, field);
        int num = this.variantTypeCounter.getCount(variantCategory);
        return size + num;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataFrame: " + String.valueOf((Object)this.variantCategory));
        sb.append(", size: " + this.posIndex.size());
        sb.append(", current index: " + this.currentIdx);
        sb.append(", memory: " + FormatUtil.formatBytes(this.sizeBytes()) + "\n");
        sb.append("\tField types:\n");
        for (VcfHeaderInfo field : this.fields) {
            sb.append("\t\t" + String.valueOf(field) + "\n");
        }
        int rowToShow = Math.min(this.posIndex.size(), 100);
        for (int i2 = 0; i2 < rowToShow; ++i2) {
            sb.append("\t" + i2 + "\t" + this.posIndex.get(i2) + (String)(this.refs != null ? "\t| " + this.refs.get(i2) : "") + (String)(this.alts != null ? "\t| " + this.alts.get(i2) : "") + "\t| ");
            for (DataFrameColumn<?> col : this.columns.values()) {
                sb.append(String.valueOf(col.get(i2)) + "\t| ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

