/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.arrays;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import org.snpsift.annotate.mem.arrays.StringArrayBase;

public class StringArray
extends StringArrayBase {
    private static final long serialVersionUID = 2024073106L;
    public static final int MAX_NUM_STRING_TO_SHOW = 10;
    protected byte[] data;
    protected int[] index2offset;
    protected int offset = 0;

    public static int sizeOf(String s) {
        int len = s == null ? 0 : s.getBytes().length;
        return len + 1;
    }

    public static int sizeOf(String[] strings) {
        int len = 0;
        for (String s : strings) {
            len += StringArray.sizeOf(s);
        }
        return len;
    }

    public static int sizeOf(Collection<String> strings) {
        int len = 0;
        for (String s : strings) {
            len += StringArray.sizeOf(s);
        }
        return len;
    }

    public static StringArray of(String[] strings) {
        StringArray sa = new StringArray(strings.length, StringArray.sizeOf(strings));
        for (String s : strings) {
            sa.add(s);
        }
        return sa;
    }

    public static StringArray of(Collection<String> strings) {
        StringArray sa = new StringArray(strings.size(), StringArray.sizeOf(strings));
        for (String s : strings) {
            sa.add(s);
        }
        return sa;
    }

    public StringArray(int numElements, int size) {
        this.data = new byte[size];
        Arrays.fill(this.data, (byte)0);
        this.index2offset = new int[numElements];
        Arrays.fill(this.index2offset, -1);
    }

    @Override
    public String get(int i2) {
        int offset = this.index2offset[i2];
        if (offset == -1) {
            return null;
        }
        return this.getByOffset(this.index2offset[i2]);
    }

    private String getByOffset(int offset) {
        int end;
        for (end = offset; end < this.data.length && this.data[end] != 0; ++end) {
        }
        return new String(this.data, offset, end - offset);
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public int set(int i2, String str) {
        if (this.index2offset[i2] != -1) {
            throw new RuntimeException("Index already set: " + i2);
        }
        this.index2offset[i2] = this.offset;
        this.currentIndex = i2 + 1;
        if (str == null) {
            str = "";
        }
        if (str.length() > 0) {
            byte[] strBytes = str.getBytes(StandardCharsets.UTF_8);
            if (this.offset + strBytes.length > this.data.length) {
                throw new RuntimeException("StringArray: Out of memory. The allocated memory is " + this.data.length + " bytes, but we need " + (this.offset + strBytes.length) + " bytes, to add new entry " + i2 + " with string '" + str + "'");
            }
            System.arraycopy(strBytes, 0, this.data, this.offset, strBytes.length);
            this.offset += strBytes.length;
        }
        this.data[this.offset++] = 0;
        return this.currentIndex;
    }

    @Override
    public int size() {
        return this.index2offset.length;
    }

    @Override
    public long sizeBytes() {
        return this.data.length + this.index2offset.length * 4;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StringArray(length: " + this.currentIndex + " / " + this.index2offset.length + ", sizeBytes: " + this.offset + " / " + this.data.length + ")");
        if (this.currentIndex > 0) {
            sb.append(":\n");
        }
        for (int i2 = 0; i2 < this.currentIndex && i2 < 10; ++i2) {
            sb.append("\t" + i2 + ": '" + this.get(i2) + "'\n");
        }
        return sb.toString();
    }
}

