/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.arrays;

import java.io.Serializable;
import java.util.Arrays;

public class PosIndex
implements Serializable {
    private static final long serialVersionUID = 2024073105L;
    int[] positions;
    int size = 0;

    public PosIndex(int numEntries) {
        this.positions = new int[numEntries];
    }

    public int capacity() {
        return this.positions.length;
    }

    public void check() {
        for (int i2 = 1; i2 < this.size; ++i2) {
            if (this.positions[i2 - 1] <= this.positions[i2]) continue;
            throw new RuntimeException("ERROR: Positions are not sorted: " + i2 + "\t" + this.positions[i2 - 1] + " >= " + this.positions[i2]);
        }
    }

    public boolean contains(int pos) {
        return this.indexOf(pos) >= 0;
    }

    public int get(int i2) {
        return this.positions[i2];
    }

    public int indexOf(int pos) {
        return Arrays.binarySearch(this.positions, 0, this.size, pos);
    }

    public int indexOfSlow(int pos) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.positions[i2] != pos) continue;
            return i2;
        }
        return -1;
    }

    public void set(int i2, int pos) {
        this.positions[i2] = pos;
        this.size = Math.max(this.size, i2 + 1);
    }

    public int size() {
        return this.size;
    }

    public long sizeBytes() {
        return this.positions.length * 4;
    }
}

