/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.arrays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.snpsift.annotate.mem.arrays.StringArrayBase;

public class EnumArray
extends StringArrayBase {
    private static final long serialVersionUID = 2024080900L;
    public static final int MAX_NUM_STRING_TO_SHOW = 10;
    public static final int MAX_NUMBER_OF_ENUM_VALUES = 255;
    protected byte[] data;
    protected ArrayList<String> ord2enum;
    protected Map<String, Integer> enum2ord;

    public EnumArray(String[] data) {
        this(data.length);
        for (String str : data) {
            this.add(str);
        }
    }

    public EnumArray(int numElements) {
        this.data = new byte[numElements];
        Arrays.fill(this.data, (byte)0);
        this.enum2ord = new HashMap<String, Integer>();
        this.ord2enum = new ArrayList();
        this.addEnum("");
    }

    public int addEnum(String str) {
        if (this.enum2ord.containsKey(str)) {
            return this.enum2ord.get(str);
        }
        int ord = this.enum2ord.size();
        if (ord > 255) {
            throw new RuntimeException("EnumArray: Too many elements. Maximum number of elements in an Enum is 255");
        }
        this.enum2ord.put(str, ord);
        this.ord2enum.add(str);
        if (this.enum2ord.size() != this.ord2enum.size()) {
            throw new RuntimeException("EnumArray: Inconsistent data structures. ord2enum.size()=" + this.ord2enum.size() + ", enum2ord.size()=" + this.enum2ord.size());
        }
        return ord;
    }

    @Override
    public String get(int i2) {
        int ord = this.getOrd(i2);
        return this.ord2enum.get(ord);
    }

    public int getOrd(int i2) {
        return this.data[i2] & 0xFF;
    }

    public int numEnums() {
        return this.ord2enum.size();
    }

    @Override
    public int set(int i2, String str) {
        if (str == null) {
            str = "";
        }
        int ord = this.addEnum(str);
        this.data[i2] = (byte)ord;
        this.currentIndex = i2 + 1;
        return this.currentIndex;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public long sizeBytes() {
        return this.data.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EnumArray: length: " + this.currentIndex + " / " + this.data.length + ", number of enums: " + this.numEnums() + "\n");
        for (int i2 = 0; i2 < this.currentIndex && i2 < 10; ++i2) {
            sb.append("\t" + i2 + ": '" + this.get(i2) + "' (" + this.getOrd(i2) + ")\n");
        }
        return sb.toString();
    }
}

