/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem.arrays;

import java.io.Serializable;
import java.util.Arrays;

public class BoolArray
implements Serializable {
    private static final long serialVersionUID = 2024073104L;
    protected byte[] bytes;

    public BoolArray(int size) {
        this.bytes = new byte[(size + 7) / 8];
        this.reset();
    }

    public void clear(int i2) {
        int n = i2 / 8;
        this.bytes[n] = (byte)(this.bytes[n] & ~(1 << i2 % 8));
    }

    public void fill() {
        Arrays.fill(this.bytes, (byte)-1);
    }

    public boolean is(int i2) {
        return (this.bytes[i2 / 8] & 1 << i2 % 8) != 0;
    }

    public void set(int i2) {
        int n = i2 / 8;
        this.bytes[n] = (byte)(this.bytes[n] | 1 << i2 % 8);
    }

    public void set(int i2, boolean value) {
        if (value) {
            this.set(i2);
        } else {
            this.clear(i2);
        }
    }

    public void reset() {
        Arrays.fill(this.bytes, (byte)0);
    }

    public int size() {
        return this.bytes.length * 8;
    }

    public int sizeBytes() {
        return this.bytes.length;
    }
}

