/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem;

import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Variant;
import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.annotate.mem.SortedVariantsVcfIterator;

public class Zzz {
    public static final int CHR1_NUM_ENTRIES = 86844566;

    public static void main(String[] args) {
    }

    public void benchmarkSortedVariantsVcfIterator(String databaseFileName) {
        int showEvery = 100000;
        long startTime = System.currentTimeMillis();
        int count = 0;
        int pos = -1;
        int countUnsorted = 0;
        String chrPrev = "";
        SortedVariantsVcfIterator sortedVariantsIterator = new SortedVariantsVcfIterator(databaseFileName);
        for (VariantVcfEntry varVcf : sortedVariantsIterator) {
            if (pos > varVcf.getStart() && chrPrev.equals(varVcf.getChromosomeName())) {
                ++countUnsorted;
            }
            chrPrev = varVcf.getChromosomeName();
            pos = varVcf.getStart();
            if (++count % showEvery != 0) continue;
            if (count % (showEvery * 100) == 0) {
                System.out.println("SORT Count: " + count + ", unsorted: " + countUnsorted + ", chr: " + varVcf.getChromosomeName() + ", pos: " + varVcf.getStart());
                continue;
            }
            System.out.print(".");
            System.out.flush();
        }
        long endTime = System.currentTimeMillis();
        System.out.println("SORT Done. Count: " + count + ", unsorted: " + countUnsorted + ", time: " + (double)(endTime - startTime) / 1000.0 + " sec");
    }

    public void benchmarkVcfIterator(String databaseFileName) {
        int showEvery = 100000;
        long startTime = System.currentTimeMillis();
        int count = 0;
        int pos = -1;
        int countUnsorted = 0;
        String chrPrev = "";
        VcfFileIterator vcfFileIterator = new VcfFileIterator(databaseFileName);
        for (VcfEntry vcfEntry : vcfFileIterator) {
            for (Variant variant : vcfEntry.variants()) {
                if (pos > variant.getStart() && chrPrev.equals(variant.getChromosomeName())) {
                    ++countUnsorted;
                }
                chrPrev = variant.getChromosomeName();
                pos = variant.getStart();
                if (++count % showEvery != 0) continue;
                if (count % (showEvery * 100) == 0) {
                    System.out.println("VCF Count: " + count + ", unsorted: " + countUnsorted + ", chr: " + variant.getChromosomeName() + ", pos: " + variant.getStart());
                    continue;
                }
                System.out.print(".");
                System.out.flush();
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("VCF Done. Count: " + count + ", unsorted: " + countUnsorted + ", time: " + (double)(endTime - startTime) / 1000.0 + " sec\n");
    }
}

