/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;

public class SortedVariantsVcfIterator
implements Iterator<VariantVcfEntry>,
Iterable<VariantVcfEntry> {
    protected String vcfFileName;
    protected VcfFileIterator vcfFileIterator;
    protected PriorityQueue<VariantVcfEntry> variantsMinHeap;
    protected String vcfChr;
    protected int vcfPos;
    protected VcfEntry vcfEntryPending;

    public static SortedVariantsVcfIterator lines2SortedVariantsVcfIterator(String vcfLines) {
        SortedVariantsVcfIterator sortedVariantsVcfIterator;
        ByteArrayInputStream bais = new ByteArrayInputStream(vcfLines.getBytes("UTF-8"));
        try {
            InputStreamReader isr = new InputStreamReader(bais);
            BufferedReader br = new BufferedReader(isr);
            sortedVariantsVcfIterator = new SortedVariantsVcfIterator(br);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bais.close();
        return sortedVariantsVcfIterator;
    }

    public SortedVariantsVcfIterator(String vcfFileName) {
        this.vcfFileName = vcfFileName;
        this.vcfFileIterator = new VcfFileIterator(vcfFileName);
        this.variantsMinHeap = new PriorityQueue<VariantVcfEntry>(Comparator.comparingInt(varvcf -> varvcf.getStart()));
        this.vcfChr = "";
        this.vcfPos = -1;
    }

    public SortedVariantsVcfIterator(BufferedReader reader) {
        this.vcfFileIterator = new VcfFileIterator(reader);
        this.variantsMinHeap = new PriorityQueue<VariantVcfEntry>(Comparator.comparingInt(varvcf -> varvcf.getStart()));
        this.vcfChr = "";
        this.vcfPos = -1;
    }

    private void addVariantsVcfToMinHeap(VcfEntry vcfEntry) {
        this.variantsMinHeap.addAll(VariantVcfEntry.factory(vcfEntry));
        this.vcfChr = vcfEntry.getChromosomeName();
        this.vcfPos = vcfEntry.getStart();
    }

    public void close() {
        this.vcfFileIterator.close();
    }

    @Override
    public Iterator<VariantVcfEntry> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return !this.variantsMinHeap.isEmpty() || this.vcfFileIterator.hasNext();
    }

    @Override
    public VariantVcfEntry next() {
        if (!this.variantsMinHeap.isEmpty() && this.variantsMinHeap.peek().getStart() <= this.vcfPos) {
            return this.variantsMinHeap.poll();
        }
        if (this.vcfEntryPending != null) {
            if (!this.variantsMinHeap.isEmpty()) {
                return this.variantsMinHeap.poll();
            }
            this.addVariantsVcfToMinHeap(this.vcfEntryPending);
            this.vcfEntryPending = null;
        }
        if (!this.vcfFileIterator.hasNext()) {
            return this.variantsMinHeap.poll();
        }
        VcfEntry vcfEntry = (VcfEntry)this.vcfFileIterator.next();
        if (!vcfEntry.getChromosomeName().equals(this.vcfChr)) {
            this.vcfEntryPending = vcfEntry;
        } else {
            if (vcfEntry.getStart() < this.vcfPos) {
                throw new RuntimeException("VCF file is not sorted. Position: " + vcfEntry.getStart() + " is before " + this.vcfPos + "\n" + String.valueOf(vcfEntry));
            }
            this.addVariantsVcfToMinHeap(vcfEntry);
        }
        return this.next();
    }
}

