/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate.mem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.snpeff.util.Log;
import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;

public class Fields
implements Iterable<VcfHeaderInfo>,
Serializable {
    private static final long serialVersionUID = 2024092801L;
    public static final Set<String> VCF_COLUMN_FIELD_NAMES = new HashSet<String>(Arrays.asList("CHROM", "POS", "ID", "QUAL", "FILTER"));
    String[] fieldNames;
    Map<String, VcfHeaderInfo> fieldByName = new HashMap<String, VcfHeaderInfo>();

    public static Object getFieldValue(VcfHeaderInfo vcfHeaderInfo, VariantVcfEntry varVcfEntry) {
        VcfInfoType type = vcfHeaderInfo.getVcfInfoType();
        VcfEntry vcfEntry = varVcfEntry.getVcfEntry();
        String fieldName = vcfHeaderInfo.getId();
        VcfHeaderInfo.VcfInfoNumber vin = vcfHeaderInfo.getVcfInfoNumber();
        String valueStr = (vin == VcfHeaderInfo.VcfInfoNumber.ALLELE || vin == VcfHeaderInfo.VcfInfoNumber.ALL_ALLELES) && type != VcfInfoType.Flag ? vcfEntry.getInfo(fieldName, varVcfEntry.getAlt()) : Fields.getFieldValueString(fieldName, vcfEntry);
        switch (type) {
            case Flag: {
                return valueStr != null;
            }
            case Integer: {
                if (valueStr == null) {
                    return null;
                }
                try {
                    return Integer.parseInt(valueStr);
                }
                catch (Exception e) {
                    Log.warning("Could not pase field '" + vcfHeaderInfo.getId() + "', value '" + valueStr + "' as integer for field '" + vcfHeaderInfo.getId() + "' in VCF entry: " + vcfEntry.getChromosomeNameOri() + ":" + (vcfEntry.getStart() + 1));
                    return null;
                }
            }
            case Float: {
                if (valueStr == null) {
                    return null;
                }
                try {
                    return Double.parseDouble(valueStr);
                }
                catch (Exception e) {
                    Log.warning("Could not pase field '" + vcfHeaderInfo.getId() + "', value '" + valueStr + "' as float for field '" + vcfHeaderInfo.getId() + "' in VCF entry: " + vcfEntry.getChromosomeNameOri() + ":" + (vcfEntry.getStart() + 1));
                    return null;
                }
            }
            case Character: {
                return valueStr != null && valueStr.length() > 0 ? Character.valueOf(valueStr.charAt(0)) : null;
            }
            case String: {
                return valueStr;
            }
        }
        throw new RuntimeException("Unimplemented type: " + String.valueOf((Object)type));
    }

    public static String getFieldValueString(String fieldName, VcfEntry vcfEntry) {
        if (VCF_COLUMN_FIELD_NAMES.contains(fieldName)) {
            switch (fieldName) {
                case "ID": {
                    return vcfEntry.getId();
                }
                case "CHROM": {
                    return vcfEntry.getChromosomeNameOri();
                }
                case "POS": {
                    return "" + (vcfEntry.getStart() + 1);
                }
                case "REF": {
                    return vcfEntry.getRef();
                }
                case "ALT": {
                    return vcfEntry.getAltsStr();
                }
                case "QUAL": {
                    return Double.toString(vcfEntry.getQuality());
                }
                case "FILTER": {
                    return vcfEntry.getFilter();
                }
            }
            throw new RuntimeException("Unimplemented field: " + fieldName);
        }
        return vcfEntry.getInfo(fieldName);
    }

    public static Fields load(String fileName) {
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                throw new RuntimeException("File not found: '" + fileName + "'");
            }
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Fields vd = (Fields)ois.readObject();
            ois.close();
            return vd;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load from file '" + fileName + "'", e);
        }
    }

    public void add(VcfHeaderInfo field) {
        this.fieldByName.put(field.getId(), field);
        this.fieldNames = null;
    }

    public VcfHeaderInfo get(String name) {
        return this.fieldByName.get(name);
    }

    public String[] getNames() {
        if (this.fieldNames == null) {
            this.fieldNames = this.fieldByName.keySet().toArray(new String[0]);
        }
        return this.fieldNames;
    }

    @Override
    public Iterator<VcfHeaderInfo> iterator() {
        return this.fieldByName.values().iterator();
    }

    public void save(String fileName) {
        try {
            Log.info("Saving to file '" + fileName + "'");
            File file = new File(fileName);
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot save to file '" + fileName + "'", e);
        }
    }

    public Collection<VcfHeaderEntry> vcfHeaders(String prefix) {
        LinkedList<VcfHeaderEntry> headerInfos = new LinkedList<VcfHeaderEntry>();
        if (prefix == null) {
            headerInfos.addAll(this.fieldByName.values());
        } else {
            for (VcfHeaderInfo field : this) {
                VcfHeaderInfo fieldToAdd = new VcfHeaderInfo(prefix + field.getId(), field.getVcfInfoType(), field.getNumberString(), field.getDescription());
                headerInfos.add(fieldToAdd);
            }
        }
        return headerInfos;
    }
}

