/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate;

import java.util.Arrays;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpsift.annotate.MarkerFile;

public class VcfIndexDataChromo {
    public static final int INITIAL_CAPACITY = 1024;
    Genome genome;
    String chromosome;
    int[] start;
    int[] end;
    long[] filePosStart;
    long filePosEnd;
    int size;

    public VcfIndexDataChromo(Genome genome) {
        this.genome = genome;
        this.size = 0;
    }

    public VcfIndexDataChromo(Genome genome, String chromosome) {
        this.genome = genome;
        this.chromosome = chromosome;
        this.start = new int[1024];
        this.end = new int[1024];
        this.filePosStart = new long[1024];
        this.size = 0;
    }

    public void add(int start, int end, long fileIdx) {
        if (this.size >= this.capacity()) {
            this.grow();
        }
        this.start[this.size] = start;
        this.end[this.size] = end;
        this.filePosStart[this.size] = fileIdx;
        ++this.size;
    }

    int capacity() {
        if (this.start == null) {
            return 0;
        }
        return this.start.length;
    }

    public long fileSize(int startIdx, int endIdx) {
        long startFilePos;
        long l = startFilePos = startIdx >= 0 ? (startFilePos = this.getFilePosStart(startIdx)) : 0L;
        if (endIdx >= this.size - 1) {
            endIdx = this.size - 2;
        }
        long endFilePos = this.getFilePosStart(endIdx + 1);
        return endFilePos - startFilePos;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public int getEnd(int idx) {
        return this.end[idx];
    }

    public long getFilePosEnd(int idx) {
        long start = this.filePosStart[idx];
        do {
            if (++idx < this.size) continue;
            return this.filePosEnd;
        } while (this.filePosStart[idx] <= start);
        return this.filePosStart[idx];
    }

    public long getFilePosStart(int idx) {
        return this.filePosStart[idx];
    }

    public int getStart(int idx) {
        return this.start[idx];
    }

    void grow() {
        int oldCapacity = this.capacity();
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        this.start = Arrays.copyOf(this.start, newCapacity);
        this.end = Arrays.copyOf(this.end, newCapacity);
        this.filePosStart = Arrays.copyOf(this.filePosStart, newCapacity);
    }

    public boolean intersects(int idx, int pos) {
        return this.start[idx] <= pos && pos <= this.end[idx];
    }

    public boolean intersects(int idx, Marker marker) {
        int iend;
        if (!this.chromosome.equals(marker.getChromosomeName())) {
            return false;
        }
        int istart = Math.max(this.start[idx], marker.getStart());
        return istart <= (iend = Math.min(this.end[idx], marker.getEnd()));
    }

    public Marker marker(int idx) {
        Chromosome chr = this.genome.getOrCreateChromosome(this.chromosome);
        return new MarkerFile(chr, this.start[idx], this.end[idx], this.filePosStart[idx]);
    }

    public void setFilePosEnd(long filePosEnd) {
        this.filePosEnd = filePosEnd;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Chromosome: " + this.chromosome + ", size: " + this.size + ", capacity: " + this.capacity() + "\n");
        for (int i2 = 0; i2 < this.size; ++i2) {
            sb.append("\t" + i2 + "\t[ " + this.start[i2] + ", " + this.end[i2] + " ]\t" + this.filePosStart[i2] + "\n");
        }
        return sb.toString();
    }
}

