/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.snpeff.fileIterator.SeekableBufferedReader;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.annotate.MarkerFile;
import org.snpsift.annotate.VcfIndexDataChromo;
import org.snpsift.annotate.VcfIndexTree;

public class VcfIndex {
    public static int INDEX_FORMAT_VERSION = 1;
    public static int SHOW_EVERY = 1000000;
    public static final String INDEX_EXT = "sidx";
    boolean verbose;
    boolean debug;
    int maxBlockSize = 16384;
    String fileName;
    Map<String, VcfIndexDataChromo> vcfIndexByChromo;
    Map<String, VcfIndexTree> forest;
    Genome genome;
    VcfFileIterator vcf;

    public VcfIndex(String fileName) {
        this.fileName = fileName;
    }

    public void add(VcfEntry ve, long filePos) {
        VcfIndexDataChromo vidc = this.getOrCreate(ve.getChromosomeName());
        List<Variant> vars = ve.variants();
        if (vars.size() == 1) {
            Variant var = vars.get(0);
            vidc.add(var.getStart(), var.getEnd(), filePos);
            return;
        }
        HashSet<CallSite> added = new HashSet<CallSite>();
        for (Variant var : vars) {
            String key = var.getStart() + "\t" + var.getEnd();
            if (!added.add((CallSite)((Object)key))) continue;
            vidc.add(var.getStart(), var.getEnd(), filePos);
        }
    }

    List<String> chromosomes() {
        ArrayList<String> chrs = new ArrayList<String>();
        if (this.vcfIndexByChromo != null) {
            chrs.addAll(this.vcfIndexByChromo.keySet());
        } else {
            chrs.addAll(this.forest.keySet());
        }
        Collections.sort(chrs);
        return chrs;
    }

    public void close() {
        if (this.vcf != null) {
            this.vcf.close();
        }
        this.vcf = null;
        this.vcfIndexByChromo = null;
        this.forest = null;
    }

    void createIntervalForest() {
        if (this.verbose) {
            Log.info("Creating interval forest:");
        }
        this.forest = new HashMap<String, VcfIndexTree>();
        for (String chr : this.chromosomes()) {
            VcfIndexDataChromo vic = this.getVcfIndexChromo(chr);
            VcfIndexTree vcfTree = new VcfIndexTree(this.vcf, vic);
            vcfTree.setMaxBlockSize(this.maxBlockSize);
            vcfTree.build();
            if (this.verbose) {
                Log.info("\t" + String.valueOf(vcfTree));
            }
            this.forest.put(chr, vcfTree);
        }
        if (this.verbose) {
            Log.info("Creating interval forest: Done");
        }
    }

    public Genome getGenome() {
        return this.genome;
    }

    public VcfIndexDataChromo getOrCreate(String chromosome) {
        VcfIndexDataChromo ifc = this.vcfIndexByChromo.get(chromosome = Chromosome.simpleName(chromosome));
        if (ifc == null) {
            ifc = new VcfIndexDataChromo(this.genome, chromosome);
            this.vcfIndexByChromo.put(chromosome, ifc);
        }
        return ifc;
    }

    public VcfIndexTree getTree(String chromosome) {
        return this.forest.get(Chromosome.simpleName(chromosome));
    }

    public VcfFileIterator getVcf() {
        return this.vcf;
    }

    public VcfIndexDataChromo getVcfIndexChromo(String chromosome) {
        return this.vcfIndexByChromo.get(Chromosome.simpleName(chromosome));
    }

    boolean hasValidIndex(String fileName, String indexFile) {
        if (Gpr.exists(indexFile)) {
            File fileIdx = new File(indexFile);
            File file = new File(fileName);
            return fileIdx.lastModified() > file.lastModified();
        }
        return false;
    }

    public void index() {
        String indexFile = this.fileName + ".sidx";
        if (this.verbose) {
            Log.info("Checking index file '" + indexFile + "'");
        }
        if (this.hasValidIndex(this.fileName, indexFile)) {
            this.loadIndex(indexFile);
            this.setVcfTree(this.vcf);
            return;
        }
        this.loadIntervals();
        this.createIntervalForest();
        this.vcfIndexByChromo = null;
        this.save(indexFile);
        this.setVcfTree(this.vcf);
    }

    protected void loadIndex(String indexFile) {
        if (this.verbose) {
            Log.info("Loading index file '" + indexFile + "'");
        }
        FilterInputStream in = null;
        this.forest = new HashMap<String, VcfIndexTree>();
        try {
            in = new DataInputStream(new GZIPInputStream(new FileInputStream(indexFile)));
            if (this.genome == null) {
                this.genome = new Genome("genome");
            }
            VcfIndexTree vcfTree = new VcfIndexTree();
            vcfTree.setVerbose(this.verbose);
            vcfTree.setDebug(this.debug);
            while (vcfTree.load((DataInputStream)in)) {
                this.forest.put(vcfTree.getChromosome(), vcfTree);
                vcfTree = new VcfIndexTree();
                vcfTree.setVerbose(this.verbose);
                vcfTree.setDebug(this.debug);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void loadIntervals() {
        if (this.verbose) {
            Log.info("Create index: Reading variants from file '" + this.fileName + "'");
        }
        try {
            this.open();
            this.vcfIndexByChromo = new HashMap<String, VcfIndexDataChromo>();
            boolean title = true;
            long pos = this.vcf.getFilePointer();
            long fileLen = new File(this.fileName).length();
            Timer timer = new Timer();
            timer.start();
            this.vcf.setErrorIfUnsorted(true);
            for (VcfEntry ve : this.vcf) {
                this.add(ve, pos);
                if (this.verbose && this.vcf.getLineNum() % SHOW_EVERY == 0) {
                    double perc = (double)pos / (double)fileLen;
                    long elapsed = timer.elapsed();
                    double remain = (double)elapsed / perc * (1.0 - perc);
                    long remainMs = (long)remain;
                    if (title) {
                        System.err.println(String.format("\t\t%8s\t%10s\t%3s\t%10s\t%10s", "LineNum", "chr:pos", "%", "Elapsed", "Remaining"));
                        title = false;
                    }
                    System.err.println(String.format("\t\t%8d\t%10s\t%.1f%%\t%10s\t%10s", this.vcf.getLineNum(), ve.getChromosomeName() + ":" + (ve.getStart() + 1), 100.0 * perc, Timer.toString(elapsed, false), Timer.toString(remainMs, false)));
                }
                pos = this.vcf.getFilePointer();
                this.getVcfIndexChromo(ve.getChromosomeName()).setFilePosEnd(pos);
            }
            this.vcf.setErrorIfUnsorted(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.verbose) {
            Log.info("Loading intervals: Done\n" + String.valueOf(this));
        }
    }

    public void open() {
        try {
            SeekableBufferedReader seekableReader = new SeekableBufferedReader(this.fileName);
            this.vcf = new VcfFileIterator(seekableReader);
            this.vcf.readHeader();
            this.genome = this.vcf.getGenome();
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found '" + this.fileName + "'");
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Markers query(Marker marker) {
        String chr = marker.getChromosomeName();
        VcfIndexTree tree = this.forest.get(chr);
        if (tree == null) {
            return new Markers();
        }
        return tree.query(marker);
    }

    public VcfEntry read(long fileIdx) {
        try {
            this.vcf.seek(fileIdx);
            return (VcfEntry)this.vcf.next();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VcfEntry read(MarkerFile markerFile) {
        return this.read(markerFile.getFileIdx());
    }

    public void save(String indexFile) {
        if (this.verbose) {
            Log.info("Saving index to file '" + indexFile + "'");
        }
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(indexFile)));
            for (String chr : this.chromosomes()) {
                this.getTree(chr).save((DataOutputStream)out);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.verbose) {
            Log.info("Saving index: Done.");
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        if (this.forest != null) {
            for (VcfIndexTree it : this.forest.values()) {
                it.setDebug(debug);
            }
        }
    }

    public void setMaxBlockSize(int maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }

    void setVcfTree(VcfFileIterator vcf) {
        for (String chr : this.chromosomes()) {
            this.getTree(chr).setVcf(vcf);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        if (this.forest != null) {
            for (VcfIndexTree it : this.forest.values()) {
                it.setVerbose(verbose);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("File '" + this.fileName + "' :\n");
        for (String chr : this.chromosomes()) {
            VcfIndexDataChromo ifc = this.getVcfIndexChromo(chr);
            sb.append("\tChoromsome:" + chr + ", size: " + ifc.size() + ", capacity: " + ifc.capacity() + "\n");
        }
        return sb.toString();
    }

    public String toStringAll() {
        StringBuilder sb = new StringBuilder();
        for (String chr : this.chromosomes()) {
            sb.append(String.valueOf(this.getVcfIndexChromo(chr)) + "\n");
        }
        for (String chr : this.chromosomes()) {
            sb.append(this.getTree(chr).toStringAll() + "\n");
        }
        return sb.toString();
    }
}

