/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate;

import htsjdk.tribble.readers.TabixReader;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.ChromosomeSimpleName;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.annotate.DbVcf;

public class DbVcfTabix
extends DbVcf {
    protected TabixReader tabixReader;
    protected VcfFileIterator vcf;
    protected String chrPrepend;

    public DbVcfTabix(String dbFileName) {
        super(dbFileName);
    }

    boolean allStartWith(String pref, Collection<String> chrNames) {
        return chrNames.stream().allMatch(chr -> chr.startsWith(pref));
    }

    @Override
    public void close() {
        if (this.tabixReader != null) {
            this.tabixReader.close();
        }
        this.tabixReader = null;
        if (this.vcf != null) {
            this.vcf.close();
        }
        this.vcf = null;
        this.vcfHeader = null;
    }

    private String chrName(Variant variant) {
        String chr = variant.getChromosomeName();
        if (this.chrPrepend.isEmpty()) {
            return chr;
        }
        if (chr.startsWith(this.chrPrepend)) {
            return chr;
        }
        return this.chrPrepend + chr;
    }

    private String findChrPrefix(Set<String> chrNames) {
        String pref = this.findCommonlyUsedPrefixes(chrNames);
        if (!pref.isEmpty()) {
            return pref;
        }
        return this.findSharedPrefix(chrNames);
    }

    private String findCommonlyUsedPrefixes(Set<String> chrNames) {
        for (String s : ChromosomeSimpleName.CHROMO_PREFIX) {
            if (this.allStartWith(s, chrNames)) {
                return s;
            }
            String sUpper = s.toUpperCase(Locale.ROOT);
            if (this.allStartWith(sUpper, chrNames)) {
                return sUpper;
            }
            String sFirstUpper = s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1);
            if (!this.allStartWith(sFirstUpper, chrNames)) continue;
            return sFirstUpper;
        }
        return "";
    }

    private String findSharedPrefix(Set<String> chrNames) {
        if (chrNames.size() < 2) {
            return "";
        }
        String prefix = chrNames.iterator().next();
        block0: for (String chr : chrNames) {
            if (chr.startsWith(prefix)) continue;
            for (int i2 = prefix.length() - 1; i2 > 0; --i2) {
                if (!chr.startsWith(prefix.substring(0, i2))) continue;
                prefix = prefix.substring(0, i2);
                continue block0;
            }
            return "";
        }
        return prefix;
    }

    protected boolean initTabix(String fileName) {
        try {
            String indexFile = fileName + ".tbi";
            if (!Gpr.exists(indexFile)) {
                throw new RuntimeException("Cannot find tabix index file '" + indexFile + "'");
            }
            this.tabixReader = new TabixReader(fileName);
            this.chrPrepend = this.findChrPrefix(this.tabixReader.getChromosomes());
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening tabix file '" + fileName + "'", e);
        }
        return true;
    }

    @Override
    public void open() {
        this.vcf = new VcfFileIterator(this.dbFileName);
        this.vcfHeader = this.vcf.readHeader();
        this.initTabix(this.dbFileName);
    }

    @Override
    public List<VariantVcfEntry> query(Variant variant) {
        int end;
        int start;
        LinkedList<VariantVcfEntry> results = new LinkedList<VariantVcfEntry>();
        String chr = this.chrName(variant);
        TabixReader.Iterator ti = this.tabixReader.query(chr, start = variant.getStart() - 1, end = variant.getEnd() + 1);
        if (ti != null) {
            try {
                String line;
                while ((line = ti.next()) != null) {
                    line = Gpr.removeBackslashR(line);
                    VcfEntry ve = this.vcf.parseVcfLine(line);
                    results.addAll(VariantVcfEntry.factory(ve));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading tabix file '" + this.dbFileName + "'", e);
            }
        }
        return results;
    }
}

