/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate;

import java.util.LinkedList;
import java.util.List;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.util.Log;
import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.annotate.DbVcf;
import org.snpsift.annotate.VcfIndex;

public class DbVcfSorted
extends DbVcf {
    VcfIndex vcfIndex;
    int maxBlockSize = 16384;

    public DbVcfSorted(String dbFileName) {
        super(dbFileName);
    }

    @Override
    public void close() {
        if (this.vcfIndex != null) {
            this.vcfIndex.close();
            this.vcfIndex = null;
        }
    }

    @Override
    public void open() {
        if (this.debug) {
            Log.debug("Open database file:" + this.dbFileName);
        }
        this.vcfIndex = new VcfIndex(this.dbFileName);
        this.vcfIndex.setVerbose(this.verbose);
        this.vcfIndex.setDebug(this.debug);
        if (this.maxBlockSize > 0) {
            this.vcfIndex.setMaxBlockSize(this.maxBlockSize);
        }
        this.vcfIndex.open();
        this.vcfHeader = this.vcfIndex.getVcf().getVcfHeader();
        this.vcfIndex.index();
    }

    @Override
    public List<VariantVcfEntry> query(Variant variant) {
        Markers results = this.vcfIndex.query(variant);
        LinkedList<VariantVcfEntry> list = new LinkedList<VariantVcfEntry>();
        for (Marker m : results) {
            VcfEntry ve = (VcfEntry)m;
            list.addAll(VariantVcfEntry.factory(ve));
        }
        return list;
    }

    public void setMaxBlockSize(int maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }
}

