/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate;

import java.util.LinkedList;
import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.interval.tree.IntervalTreeArray;
import org.snpeff.interval.tree.Itree;
import org.snpeff.util.Log;
import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.annotate.DbVcf;

public class DbVcfMem
extends DbVcf {
    public static final int SHOW = 10000;
    public static final int SHOW_LINES = 1000000;
    Itree itree;

    public DbVcfMem(String dbFileName) {
        super(dbFileName);
    }

    @Override
    public void close() {
    }

    void loadDatabase() {
        if (this.verbose) {
            Log.info("Loading database: '" + this.dbFileName + "'");
        }
        VcfFileIterator dbFile = new VcfFileIterator(this.dbFileName);
        dbFile.setDebug(this.debug);
        int count = 0;
        this.itree = new IntervalTreeArray();
        for (VcfEntry vcfDbEntry : dbFile) {
            if (this.vcfHeader == null) {
                this.vcfHeader = dbFile.getVcfHeader();
            }
            for (VariantVcfEntry varVe : VariantVcfEntry.factory(vcfDbEntry)) {
                this.itree.add(varVe);
                ++count;
                if (!this.verbose) continue;
                if (count % 1000000 == 0) {
                    System.err.print("\n" + count + "\t.");
                    continue;
                }
                if (count % 10000 != 0) continue;
                System.err.print('.');
            }
        }
        if (this.verbose) {
            System.err.println("");
            Log.info("Done. Added: " + this.itree.size());
        }
        if (this.verbose) {
            Log.info("Building interval tree");
        }
        this.itree.build();
        if (this.verbose) {
            Log.info("Done");
        }
    }

    @Override
    public void open() {
        this.loadDatabase();
    }

    @Override
    public List<VariantVcfEntry> query(Variant variant) {
        Markers results = this.itree.query(variant);
        LinkedList<VariantVcfEntry> list = new LinkedList<VariantVcfEntry>();
        for (Marker m : results) {
            list.add((VariantVcfEntry)m);
        }
        return list;
    }
}

