/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpsift.annotate.DbVcf;
import org.snpsift.annotate.QueryResult;

public abstract class AnnotateVcfDb {
    public static final int MAX_ERRORS = 10;
    protected boolean verbose;
    protected boolean debug;
    protected boolean annotateEmpty;
    protected boolean hasVcfInfoPerAlleleRef = false;
    protected boolean useId = true;
    protected boolean useInfoFields = true;
    protected boolean useAllInfoFields = true;
    protected boolean useRefAlt = true;
    protected String chrPrev = "";
    protected String existsInfoField = null;
    protected String prependInfoFieldName;
    protected DbVcf dbVcf;
    protected VcfFileIterator vcfDbFile;
    protected HashMap<String, Integer> errCount;
    protected Set<String> infoFields;
    protected Map<String, Boolean> vcfInfoPerAllele = new HashMap<String, Boolean>();
    protected Map<String, Boolean> vcfInfoPerAlleleRef = new HashMap<String, Boolean>();

    public boolean annotate(VcfEntry vcfEntry) throws IOException {
        boolean annotated = false;
        HashSet<String> idSet = new HashSet<String>();
        HashMap<String, String> infos = new HashMap<String, String>();
        boolean exists = false;
        LinkedList<QueryResult> queryResults = new LinkedList<QueryResult>();
        HashSet<VcfEntry> uniqueVcfEntries = new HashSet<VcfEntry>();
        for (Variant var : vcfEntry.variants()) {
            if (var.isStructuralHuge()) continue;
            Collection<VariantVcfEntry> results = this.query(var);
            for (VariantVcfEntry dbEntry : results) {
                uniqueVcfEntries.add(dbEntry.getVcfEntry());
            }
            QueryResult qr = new QueryResult(var, results);
            queryResults.add(qr);
            if (!this.debug) continue;
            Log.debug("Adding QueryResult: " + String.valueOf(qr));
        }
        if (this.useAllInfoFields) {
            for (VcfEntry ve : uniqueVcfEntries) {
                this.discoverInfoFields(ve);
            }
        }
        this.findDbInfoRef(infos, uniqueVcfEntries);
        for (QueryResult qr : queryResults) {
            if (this.debug) {
                Log.debug("Processing QueryResult: " + String.valueOf(qr));
            }
            if (this.useId) {
                this.findDbId(idSet, qr);
            }
            if (this.existsInfoField != null) {
                exists |= this.findDbExists(qr);
            }
            if (!this.useInfoFields) continue;
            this.findDbInfo(infos, qr);
        }
        annotated |= this.annotateIds(vcfEntry, idSet);
        annotated |= this.annotateInfo(vcfEntry, infos);
        if (exists) {
            annotated |= this.annotateExists(vcfEntry);
        }
        return annotated;
    }

    protected boolean annotateExists(VcfEntry vcfEntry) {
        vcfEntry.addInfo(this.existsInfoField, null);
        return true;
    }

    protected boolean annotateIds(VcfEntry vcfEntry, Set<String> idSet) {
        if (idSet.isEmpty()) {
            return false;
        }
        boolean annotated = false;
        Object id = this.uniqueIds(idSet, vcfEntry.getId());
        if (!((String)id).isEmpty()) {
            annotated = true;
            if (!vcfEntry.getId().isEmpty()) {
                id = vcfEntry.getId() + ";" + (String)id;
            }
            vcfEntry.setId((String)id);
        }
        return annotated;
    }

    protected boolean annotateInfo(VcfEntry vcfEntry, Map<String, String> info) {
        if (info == null || info.isEmpty()) {
            return false;
        }
        boolean annotated = false;
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(info.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String value = info.get(key);
            if (!this.annotateEmpty && VcfEntry.isEmpty(value)) continue;
            if (this.prependInfoFieldName != null) {
                key = this.prependInfoName(key);
            }
            vcfEntry.addInfo(key, value);
            annotated = true;
        }
        return annotated;
    }

    public void close() {
        this.dbVcf.close();
    }

    protected void discoverInfoFields() {
        if (this.infoFields == null) {
            this.infoFields = new HashSet<String>();
        }
        if (!this.useAllInfoFields) {
            return;
        }
        if (this.dbVcf != null && this.dbVcf.getVcfHeader() != null) {
            for (VcfHeaderInfo vcfInfo : this.dbVcf.getVcfHeader().getVcfHeaderInfo()) {
                if (vcfInfo.isImplicit()) continue;
                String infoFieldName = vcfInfo.getId();
                this.infoFields.add(infoFieldName);
                this.isVcfInfoPerAllele(infoFieldName);
                this.isVcfInfoPerAlleleRef(infoFieldName);
            }
        }
    }

    protected void discoverInfoFields(VcfEntry dbVcfEntry) {
        for (String info : dbVcfEntry.getInfoKeys()) {
            if (info.isEmpty()) continue;
            this.infoFields.add(info);
        }
    }

    public List<VcfEntry> find(Variant var) {
        return null;
    }

    public List<VcfEntry> find(VcfEntry vcfEntry) {
        List<Variant> vars = vcfEntry.variants();
        LinkedList<VcfEntry> ves = new LinkedList<VcfEntry>();
        for (Variant var : vars) {
            ves.addAll(this.find(var));
        }
        return ves;
    }

    protected boolean findDbExists(QueryResult qr) {
        return qr.results != null && !qr.results.isEmpty();
    }

    protected void findDbId(Set<String> idSet, QueryResult qr) {
        for (VariantVcfEntry dbEntry : qr.results) {
            if (dbEntry == null) {
                return;
            }
            for (String id : dbEntry.getVcfEntry().getId().split(";")) {
                idSet.add(id);
            }
        }
    }

    protected void findDbInfo(Map<String, String> info, QueryResult qr) {
        for (String infoFieldName : this.infoFields) {
            String newValue;
            if (this.isVcfInfoPerAllele(infoFieldName)) {
                newValue = this.findDbInfoAlt(infoFieldName, qr);
                this.findDbInfoAddValue(info, infoFieldName, newValue);
                continue;
            }
            if (info.containsKey(infoFieldName)) continue;
            newValue = this.findDbInfo(infoFieldName, qr);
            this.findDbInfoAddValue(info, infoFieldName, newValue);
        }
    }

    protected String findDbInfo(String infoFieldName, QueryResult qr) {
        if (this.debug) {
            Log.debug("Finding DB data for INFO field: " + infoFieldName);
        }
        StringBuilder sb = new StringBuilder();
        for (VariantVcfEntry varVe : qr.results) {
            String val;
            if (varVe == null || VcfEntry.isEmpty(val = varVe.getVcfEntry().getInfo(infoFieldName))) continue;
            if (this.debug) {
                Log.debug("\tFound: " + val);
            }
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(val);
        }
        return sb.length() <= 0 ? null : sb.toString();
    }

    void findDbInfoAddValue(Map<String, String> info, String infoFieldName, String newValue) {
        String oldValue;
        if (newValue == null && !this.annotateEmpty) {
            return;
        }
        if (this.debug) {
            Log.debug("\tINFO:" + infoFieldName + "\tnewValue: " + newValue);
        }
        String val = (String)((oldValue = info.get(infoFieldName)) == null ? "" : oldValue + ",") + (newValue != null ? newValue : ".");
        info.put(infoFieldName, val);
    }

    protected String findDbInfoAlt(String infoFieldName, QueryResult qr) {
        for (VariantVcfEntry varVe : qr.results) {
            String val;
            if (varVe == null || VcfEntry.isEmpty(val = varVe.getVcfEntry().getInfo(infoFieldName, qr.variant))) continue;
            return val;
        }
        return ".";
    }

    protected void findDbInfoRef(Map<String, String> info, Set<VcfEntry> uniqueVcfEntries) {
        if (!this.useInfoFields || !this.hasVcfInfoPerAlleleRef) {
            return;
        }
        for (String infoFieldName : this.infoFields) {
            VcfEntry dbVcfEntry;
            if (!this.isVcfInfoPerAlleleRef(infoFieldName)) continue;
            String val = null;
            Iterator<VcfEntry> iterator = uniqueVcfEntries.iterator();
            while (iterator.hasNext() && VcfEntry.isEmpty(val = (dbVcfEntry = iterator.next()).getInfo(infoFieldName, dbVcfEntry.getRef()))) {
                val = null;
            }
            if (val == null) {
                val = ".";
            }
            info.put(infoFieldName, val);
        }
    }

    boolean isVcfInfoPerAllele(String fieldName) {
        if (this.vcfInfoPerAllele.get(fieldName) == null) {
            VcfHeaderInfo vcfInfo = this.dbVcf.getVcfHeader().getVcfHeaderInfo(fieldName);
            boolean isPerAllele = vcfInfo != null && (vcfInfo.isNumberOnePerAllele() || vcfInfo.isNumberAllAlleles());
            this.vcfInfoPerAllele.put(fieldName, isPerAllele);
        }
        return this.vcfInfoPerAllele.get(fieldName);
    }

    boolean isVcfInfoPerAlleleRef(String fieldName) {
        if (this.vcfInfoPerAlleleRef.get(fieldName) == null) {
            VcfHeaderInfo vcfInfo = this.dbVcf.getVcfHeader().getVcfHeaderInfo(fieldName);
            boolean isPerAlleleRef = vcfInfo != null && vcfInfo.isNumberAllAlleles();
            this.vcfInfoPerAlleleRef.put(fieldName, isPerAlleleRef);
            this.hasVcfInfoPerAlleleRef |= isPerAlleleRef;
        }
        return this.vcfInfoPerAlleleRef.get(fieldName);
    }

    protected boolean match(Variant var, VariantVcfEntry dbEntry) {
        if (var.getChromosomeName().equals(dbEntry.getChromosomeName()) && var.getStart() == dbEntry.getStart() && var.getEnd() == dbEntry.getEnd()) {
            if (this.useRefAlt) {
                if (var.getReference().equalsIgnoreCase(dbEntry.getReference()) && var.getAlt().equalsIgnoreCase(dbEntry.getAlt())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public void open() {
        this.dbVcf.open();
        this.discoverInfoFields();
    }

    protected String prependInfoName(String infoStr) {
        if (infoStr == null || infoStr.isEmpty()) {
            return infoStr;
        }
        StringBuilder sb = new StringBuilder();
        for (String f : infoStr.split(";")) {
            sb.append((sb.length() > 0 ? ";" : "") + this.prependInfoFieldName + f);
        }
        return sb.toString();
    }

    protected Collection<VariantVcfEntry> query(Variant variant) {
        Collection<VariantVcfEntry> results = this.dbVcf.query(variant);
        LinkedList<VariantVcfEntry> list = new LinkedList<VariantVcfEntry>();
        for (VariantVcfEntry dbEntry : results) {
            if (this.match(variant, dbEntry)) {
                if (this.debug) {
                    Log.debug("dbEntry matches query\n\tvariant: " + String.valueOf(variant) + "\n\tdbEntry: " + String.valueOf(dbEntry));
                }
                list.add(dbEntry);
                continue;
            }
            if (!this.debug) continue;
            Log.debug("dbEntry does NOT match query\n\tvariant: " + String.valueOf(variant) + "\n\tdbEntry: " + String.valueOf(dbEntry));
        }
        if (this.debug) {
            Log.debug("Match query results: " + list.size());
        }
        return list;
    }

    public void setAnnotateEmpty(boolean annotateEmpty) {
        this.annotateEmpty = annotateEmpty;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.dbVcf.setDebug(debug);
    }

    public void setExistsInfoField(String existsInfoField) {
        this.existsInfoField = existsInfoField;
    }

    public void setInfoFields(boolean useInfoFields, Collection<String> infoFields) {
        this.useInfoFields = useInfoFields;
        this.useAllInfoFields = false;
        if (useInfoFields) {
            if (infoFields == null) {
                this.infoFields = null;
                if (useInfoFields) {
                    this.useAllInfoFields = true;
                }
            } else {
                this.infoFields = new HashSet<String>();
                this.infoFields.addAll(infoFields);
            }
        } else {
            this.infoFields = null;
        }
    }

    public void setPrependInfoFieldName(String prependInfoFieldName) {
        this.prependInfoFieldName = prependInfoFieldName;
    }

    public void setUseId(boolean useId) {
        this.useId = useId;
    }

    public void setUseRefAlt(boolean useRefAlt) {
        this.useRefAlt = useRefAlt;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.dbVcf.setVerbose(verbose);
    }

    public String toString() {
        return "Annotate VCF db:\n\n\tannotateEmpty        :" + this.annotateEmpty + "\n\texistsInfoField      :" + this.existsInfoField + "\n\tprependInfoFieldName :" + this.prependInfoFieldName + "\n\tuseRefAlt            :" + this.useRefAlt + "\n\tdbVcf:\n" + Gpr.prependEachLine("\t\t", this.dbVcf);
    }

    protected String uniqueIds(Set<String> idSetDb, String idStrVcf) {
        String[] idsVcf;
        for (String id : idsVcf = idStrVcf.split(";")) {
            idSetDb.remove(id);
        }
        StringBuilder sbId = new StringBuilder();
        ArrayList<String> idsSorted = new ArrayList<String>();
        idsSorted.addAll(idSetDb);
        Collections.sort(idsSorted);
        for (String id : idsSorted) {
            sbId.append((sbId.length() > 0 ? ";" : "") + id);
        }
        return sbId.toString();
    }

    protected void warn(String warn) {
        if (!this.errCount.containsKey(warn)) {
            this.errCount.put(warn, 0);
        }
        int count = this.errCount.get(warn);
        this.errCount.put(warn, count + 1);
        if (count < 10) {
            System.err.println("WARNING: " + warn);
        }
    }
}

