/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.SnpSift;

public class SnpSiftCmdVcfCheck
extends SnpSift {
    public SnpSiftCmdVcfCheck() {
    }

    public SnpSiftCmdVcfCheck(String[] args) {
        super(args);
        this.args = args;
    }

    void check(String vcfFile) {
        if (this.verbose) {
            Log.info("Processing file '" + vcfFile + "'");
        }
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        vcf.setDebug(true);
        int count = 1;
        for (VcfEntry ve : vcf) {
            Gpr.showMark(count++, 1000);
        }
        if (this.verbose) {
            Log.info("Finished file '" + vcfFile + "'");
        }
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        if (args.length < 1) {
            this.usage(null);
        }
    }

    @Override
    public boolean run() {
        for (String vcfFile : this.args) {
            this.check(vcfFile);
        }
        return true;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar vcfCheck file_1.vcf [file_2.vcf ... file_N.vcf]");
        System.exit(1);
    }
}

