/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.HashSet;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.SnpSift;

public class SnpSiftCmdRmInfo
extends SnpSift {
    String vcfFileName;
    HashSet<String> infos;
    boolean rmId;

    public SnpSiftCmdRmInfo() {
    }

    public SnpSiftCmdRmInfo(String[] args) {
        super(args);
    }

    @Override
    public void parseArgs(String[] args) {
        this.infos = new HashSet();
        this.rmId = false;
        if (args.length == 0) {
            this.usage(null);
        }
        for (String arg : args) {
            if (this.isOpt(arg)) {
                if (arg.equals("-id")) {
                    this.rmId = true;
                    continue;
                }
                this.usage("Unknown option " + arg);
                continue;
            }
            if (this.vcfFileName == null) {
                this.vcfFileName = arg;
                continue;
            }
            this.infos.add(arg);
        }
        if (this.infos.size() <= 0 && !this.rmId) {
            this.usage("No INFO field names provided.");
        }
    }

    @Override
    public boolean run() {
        Log.info("Reading STDIN");
        VcfFileIterator vcfFile = new VcfFileIterator(this.vcfFileName);
        vcfFile.setDebug(this.debug);
        int entryNum = 1;
        for (VcfEntry vcfEntry : vcfFile) {
            String headerStr;
            if (entryNum == 1 && !(headerStr = vcfFile.getVcfHeader().toString()).isEmpty()) {
                System.out.println(headerStr);
            }
            for (String info : this.infos) {
                vcfEntry.rmInfo(info);
            }
            if (this.rmId) {
                vcfEntry.setId("");
            }
            System.out.println(vcfEntry);
            ++entryNum;
        }
        Log.info("Done");
        return true;
    }

    @Override
    public void usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("Error: " + errMsg);
        }
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar rmInfo [options] file.vcf infoField_1 infoField_2 ... infoField_N > file_out.vcf");
        System.exit(1);
    }
}

