/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.ped.PedPedigree;
import org.snpeff.ped.TfamEntry;
import org.snpeff.stats.CountByType;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpsift.SnpSift;

public class SnpSiftCmdPrivate
extends SnpSift {
    boolean headerSummary = true;
    int countLines = 0;
    int countAnnotated = 0;
    String tfamFile;
    String[] sampleNum2group;
    List<String> sampleIds;
    PedPedigree pedigree;

    public SnpSiftCmdPrivate() {
    }

    public SnpSiftCmdPrivate(String[] args) {
        super(args);
    }

    @Override
    public boolean annotate(VcfEntry ve) {
        String privateGorup = this.privateGroup(ve);
        if (privateGorup != null) {
            ve.addInfo("Private", privateGorup);
            ++this.countAnnotated;
            return true;
        }
        ++this.countLines;
        return false;
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        this.loadTfam();
        this.countLines = 0;
        this.countAnnotated = 0;
        return true;
    }

    void loadTfam() {
        if (this.verbose) {
            Log.info("Loading TFAM file '" + this.tfamFile + "'");
        }
        this.pedigree = new PedPedigree();
        this.pedigree.loadTfam(this.tfamFile);
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length <= 0) {
            this.usage(null);
        }
        for (int argc = 0; argc < args.length; ++argc) {
            if (this.isOpt(args[argc])) {
                this.usage("Unknown option '" + args[argc] + "'");
                continue;
            }
            if (this.tfamFile == null) {
                this.tfamFile = args[argc];
                continue;
            }
            if (this.vcfInputFile != null) continue;
            this.vcfInputFile = args[argc];
        }
        if (this.tfamFile == null) {
            this.usage("Missing paramter 'file.tped'");
        }
    }

    List<String> parseSampleIds(VcfFileIterator vcf) {
        this.sampleIds = vcf.getSampleNames();
        CountByType countByGroup = new CountByType();
        this.sampleNum2group = new String[this.sampleIds.size()];
        int sampleNum = 0;
        int missing = 0;
        for (String id : this.sampleIds) {
            TfamEntry tfam = this.pedigree.get(id);
            String groupId = "";
            if (tfam == null) {
                ++missing;
                System.err.println("WARNING: VCF sample '" + id + "' not found in TFAM file.");
            } else {
                groupId = tfam.getFamilyId();
            }
            this.sampleNum2group[sampleNum] = groupId;
            countByGroup.inc(groupId);
            ++sampleNum;
        }
        if (missing == this.sampleIds.size()) {
            throw new RuntimeException("All samples are missing in TFAM file!");
        }
        if (this.verbose) {
            Log.info("Counts by group:\nGroup\tCount\n" + String.valueOf(countByGroup));
        }
        return this.sampleIds;
    }

    String privateGroup(VcfEntry ve) {
        String groupPrev = null;
        int sampleNum = 0;
        for (VcfGenotype gen : ve) {
            String group;
            if (gen.isVariant() && !(group = this.sampleNum2group[sampleNum]).isEmpty()) {
                if (groupPrev == null) {
                    groupPrev = group;
                } else if (!group.equals(groupPrev)) {
                    return null;
                }
            }
            ++sampleNum;
        }
        return groupPrev;
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        ArrayList<VcfEntry> vcfEntries = new ArrayList<VcfEntry>();
        VcfFileIterator vcf = this.openVcfInputFile();
        vcf.setDebug(this.debug);
        this.annotateInit(vcf);
        for (VcfEntry ve : vcf) {
            if (vcf.isHeadeSection()) {
                this.sampleIds = this.parseSampleIds(vcf);
                vcf.getVcfHeader().addLine("##INFO=<ID=Private,Number=1,Type=String,Description=\"If the variant is private (i.e. belongs only to one group or family) the group name is shown. Groups from file = '" + this.tfamFile + "'\">");
                if (!createList) {
                    System.out.println(vcf.getVcfHeader());
                }
                this.vcfHeaderProcessed = true;
            }
            this.annotate(ve);
            if (createList) {
                vcfEntries.add(ve);
                continue;
            }
            System.out.println(ve);
        }
        if (this.verbose) {
            Log.info("Done.\n\tVCF entries: " + this.countLines + "\n\tVCF entries annotated: " + this.countAnnotated);
        }
        this.annotateFinish(vcf);
        return vcfEntries;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar private file.tfam file.vcf");
        System.err.println("Where:");
        System.err.println("\tfile.tfam  : File with genotypes and groups information (in PLINK's TFAM format)");
        System.err.println("\tfile.vcf   : A VCF file (variants and genotype data). Default: 'STDIN'");
        System.exit(1);
    }
}

