/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpsift.SnpSift;
import org.snpsift.pedigree.Individual;
import org.snpsift.pedigree.PedigreeDraw;

public class SnpSiftCmdPedShow
extends SnpSift {
    String tfamFileName;
    String vcfFileName;
    String outputDir;
    List<String> sampleNames = null;
    HashMap<String, Boolean> chrPos = null;

    public SnpSiftCmdPedShow() {
    }

    public SnpSiftCmdPedShow(String[] args) {
        super(args);
    }

    void colorize(PedigreeDraw pedigree, VcfEntry vcfEntry, List<String> sampleNames) {
        int i2 = 0;
        for (VcfGenotype vcfGen : vcfEntry) {
            String sname = sampleNames.get(i2);
            Individual ind = pedigree.get(sname);
            if (ind != null) {
                int code = vcfGen.getGenotypeCode();
                if (code == 0) {
                    ind.setColor("grey");
                } else if (code == 1) {
                    ind.setColor("green");
                } else if (code == 2) {
                    ind.setColor("red");
                } else if (code < 0) {
                    ind.setColor("black");
                }
            } else {
                System.err.println("Individual '" + sname + "' not found in pedigree");
            }
            ++i2;
        }
    }

    void draw(PedigreeDraw pedigree, VcfEntry vcfEntry, String outDir) {
        String dir = outDir + "/" + vcfEntry.getChromosomeName() + "_" + (vcfEntry.getStart() + 1);
        if (this.verbose) {
            Log.info("Creating dir '" + dir + "'");
        }
        new File(dir).mkdir();
        String chrPosStr = vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1);
        Log.info("Drawing pedigree for '" + chrPosStr + "', output dir: " + dir);
        pedigree.drawSvgByFamily(dir, vcfEntry.toString());
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: " + SnpSiftCmdPedShow.class.getSimpleName() + " pedigree.txt file.vcf outDir [chr:pos1 chr:pos2 ... chr:posN]");
            System.exit(-1);
        }
        this.chrPos = new HashMap();
        int idx = 0;
        for (idx = 0; idx < args.length; ++idx) {
            String arg = args[idx];
            if (this.isOpt(arg)) {
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.tfamFileName == null) {
                this.tfamFileName = args[idx];
                continue;
            }
            if (this.vcfFileName == null) {
                this.vcfFileName = args[idx];
                continue;
            }
            if (this.outputDir == null) {
                this.outputDir = args[idx];
                continue;
            }
            this.chrPos.put(arg, false);
        }
    }

    @Override
    public boolean run() {
        PedigreeDraw pedigree = null;
        VcfFileIterator vcfFile = new VcfFileIterator(this.vcfFileName);
        vcfFile.setDebug(this.debug);
        new File(this.outputDir).mkdir();
        Log.info("Reading vcf file '" + this.vcfFileName + "'");
        for (VcfEntry vcfEntry : vcfFile) {
            if (this.sampleNames == null) {
                this.sampleNames = vcfFile.getSampleNames();
            }
            String chrPosStr = vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1);
            if (this.chrPos != null && !this.chrPos.containsKey(chrPosStr)) continue;
            pedigree = new PedigreeDraw(this.tfamFileName);
            this.colorize(pedigree, vcfEntry, this.sampleNames);
            this.draw(pedigree, vcfEntry, this.outputDir);
            if (this.chrPos == null) continue;
            this.chrPos.put(chrPosStr, true);
        }
        vcfFile.close();
        Log.info("Done");
        if (this.chrPos != null) {
            for (Map.Entry entry : this.chrPos.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                System.err.println("Entry '" + (String)entry.getKey() + "' not found.");
            }
        }
        return true;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar pedShow pedigree.tfam file.vcf outDir [chr:pos1 chr:pos2 ... chr:posN]");
    }
}

