/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.List;
import org.snpeff.fileIterator.GenericMarkerFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.GenericMarker;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpsift.SnpSift;

public class SnpSiftCmdJoin
extends SnpSift {
    boolean showEmpty;
    boolean showAll;
    boolean showClosest;
    String[] file;
    int[] inOffset;
    int[] colChr;
    int[] colStart;
    int[] colEnd;
    Genome genome = new Genome("genome");
    List<GenericMarker>[] list;
    SnpEffectPredictor snpEffectPredictor = new SnpEffectPredictor(this.genome);

    public SnpSiftCmdJoin() {
    }

    public SnpSiftCmdJoin(String[] args) {
        super(args);
    }

    void build(List<GenericMarker> list) {
        if (this.verbose) {
            Log.info("Creating interval forest");
        }
        for (Marker marker : list) {
            this.snpEffectPredictor.add(marker);
        }
        if (this.verbose) {
            Log.info("Building interval forest");
        }
        this.snpEffectPredictor.setUseChromosomes(false);
        this.snpEffectPredictor.buildForest();
    }

    GenericMarker closest(GenericMarker marker) {
        String chr = marker.getChromosomeName();
        Chromosome chromo = this.genome.getChromosome(chr);
        int minAddSize = 100;
        int maxAddSize = chromo.size() / 2;
        for (int add = minAddSize; add < maxAddSize; add += add) {
            GenericMarker m = new GenericMarker(marker.getParent(), marker.getStart() - add, marker.getEnd() + add, marker.getId());
            Markers markers = this.snpEffectPredictor.query(m);
            if (markers.size() <= 0) continue;
            int min = Integer.MAX_VALUE;
            GenericMarker gmMin = null;
            for (Marker mm : markers) {
                int dist = marker.distance(mm);
                if (min <= dist) continue;
                min = dist;
                gmMin = (GenericMarker)mm;
            }
            return gmMin;
        }
        return null;
    }

    @Override
    public void init() {
        super.init();
        this.file = new String[2];
        this.inOffset = new int[2];
        this.colChr = new int[2];
        this.colStart = new int[2];
        this.colEnd = new int[2];
        this.verbose = false;
        this.showEmpty = false;
        this.showAll = false;
        this.showClosest = false;
        this.list = new ArrayList[2];
        for (int i2 = 0; i2 < 2; ++i2) {
            this.list[i2] = new ArrayList<GenericMarker>();
        }
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].startsWith("-")) {
                if (args[i2].equals("-if1")) {
                    if (i2 + 1 >= args.length) continue;
                    this.inOffset[0] = Gpr.parseIntSafe(args[++i2]);
                    continue;
                }
                if (args[i2].equals("-if2")) {
                    if (i2 + 1 >= args.length) continue;
                    this.inOffset[1] = Gpr.parseIntSafe(args[++i2]);
                    continue;
                }
                if (args[i2].equals("-cols1")) {
                    if (i2 + 1 >= args.length) continue;
                    this.parseCols(0, args[++i2]);
                    continue;
                }
                if (args[i2].equals("-cols2")) {
                    if (i2 + 1 >= args.length) continue;
                    this.parseCols(1, args[++i2]);
                    continue;
                }
                if (args[i2].equals("-v")) {
                    this.verbose = true;
                    continue;
                }
                if (args[i2].equals("-empty")) {
                    this.showEmpty = true;
                    continue;
                }
                if (args[i2].equals("-all")) {
                    this.showAll = true;
                    continue;
                }
                if (!args[i2].equals("-closest")) continue;
                this.showClosest = true;
                continue;
            }
            if (this.file[0] == null) {
                this.file[0] = args[i2];
                continue;
            }
            if (this.file[1] != null) continue;
            this.file[1] = args[i2];
        }
        if (this.file[0] == null) {
            this.usage("Missing file1");
        }
        if (this.file[1] == null) {
            this.usage("Missing file2");
        }
    }

    void parseCols(int num, String columnDef) {
        if ((columnDef = columnDef.toLowerCase()).equals("bed")) {
            this.colChr[num] = 0;
            this.colStart[num] = 1;
            this.colEnd[num] = 2;
            this.inOffset[num] = 0;
        } else if (columnDef.equals("vcf")) {
            this.colChr[num] = 0;
            this.colStart[num] = 1;
            this.colEnd[num] = 1;
            this.inOffset[num] = 1;
        } else {
            String[] fields = columnDef.split(",");
            if (fields.length >= 2) {
                this.colChr[num] = Gpr.parseIntSafe(fields[0]) - 1;
                this.colStart[num] = Gpr.parseIntSafe(fields[1]) - 1;
                this.colEnd[num] = fields.length >= 2 ? Gpr.parseIntSafe(fields[2]) - 1 : this.colStart[num];
            } else {
                this.usage("Error parsing oclumn definition: '" + columnDef + "'");
            }
        }
    }

    void readFiles() {
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this.verbose) {
                Log.info("Reading file '" + this.file[i2] + "'");
            }
            this.list[i2] = this.readMarkers(i2);
            this.updateChromos(this.list[i2]);
            if (!this.verbose) continue;
            Log.info("Done, " + this.list[i2].size());
        }
    }

    ArrayList<GenericMarker> readMarkers(int num) {
        ArrayList<GenericMarker> list = new ArrayList<GenericMarker>();
        GenericMarkerFileIterator gmfi = new GenericMarkerFileIterator(this.file[num], this.colChr[num], this.colStart[num], this.colEnd[num], this.inOffset[num]);
        for (GenericMarker gm : gmfi) {
            list.add(gm);
        }
        return list;
    }

    @Override
    public boolean run() {
        this.readFiles();
        this.build(this.list[1]);
        int countIntersect = 0;
        for (GenericMarker m : this.list[0]) {
            Markers markers = this.snpEffectPredictor.query(m);
            if (markers.size() > 0) {
                ++countIntersect;
                int max = 0;
                GenericMarker gmMax = null;
                for (Marker mm : markers) {
                    GenericMarker gm = (GenericMarker)mm;
                    if (this.showAll) {
                        System.out.println("INTERSECT\t" + m.getLine() + "\t" + gm.getLine());
                        continue;
                    }
                    int size = m.intersectSize(mm);
                    if (max >= size) continue;
                    max = size;
                    gmMax = gm;
                }
                if (this.showAll) continue;
                System.out.println("INTERSECT\t" + m.getLine() + "\t" + gmMax.getLine());
                continue;
            }
            if (this.showClosest) {
                GenericMarker gmClosest = this.closest(m);
                if (gmClosest != null) {
                    System.out.println("CLOSEST\t" + m.getLine() + "\t" + gmClosest.getLine());
                    continue;
                }
                if (!this.showEmpty) continue;
                System.out.println("NONE\t" + m.getLine());
                continue;
            }
            if (!this.showEmpty) continue;
            System.out.println("NONE\t" + m.getLine());
        }
        if (this.verbose) {
            double perc = 100.0 * (double)countIntersect / (double)this.list[0].size();
            Log.info("Done.\n\tTotal intervals: " + this.list[0].size() + "\n\tTotal intersected: " + countIntersect + " " + String.format("(%.2f%%)", perc));
        }
        return true;
    }

    void updateChromos(List<GenericMarker> list) {
        for (Marker marker : list) {
            String chr = marker.getChromosomeName();
            Chromosome chromo = this.genome.getChromosome(chr);
            if (chromo == null) {
                chromo = new Chromosome(this.genome, 0, 0, chr);
                this.genome.add(chromo);
            }
            if (chromo.getEnd() >= marker.getEnd()) continue;
            chromo.setEnd(marker.getEnd());
        }
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar join [options] file1 file2 \nNote: It is assumed that both files fit in memory.");
        System.err.println("Options:");
        System.err.println("\t-if1 <num>       : Offset for file1 (e.g. 1 if coordinates are one-based. Default: 1");
        System.err.println("\t-if2 <num>       : Offset for file2 (e.g. 2 if coordinates are one-based. Default: 1");
        System.err.println("\t-cols1 <colDef>  : Column definition for file 1. Format: chrCol,startCol,endCol (e.g. '1,2,3'). Shortcuts 'bed' or 'vcf' are allowed. Default: 'vcf'");
        System.err.println("\t-cols2 <colDef>  : Column definition for file 2. Format: chrCol,startCol,endCol (e.g. '1,2,3'). Shortcuts 'bed' or 'vcf' are allowed. Default: 'vcf'");
        System.err.println("\t-all             : For each interval, show all intersecting. Default: show only one (largest intersection)");
        System.err.println("\t-closest         : Show closest intervals in file2 if none intersect. Default: off");
        System.err.println("\t-empty           : Show intervals in file1 even if they do not intersect with any other interval. Default: off");
        System.exit(1);
    }
}

