/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.snpeff.fileIterator.BedFileIterator;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.FileIndexChrPos;
import org.snpsift.SnpSift;

public class SnpSiftCmdIntervalsIndex
extends SnpSift {
    boolean listCommandLine;
    List<Variant> seqChanges;
    Genome genome;
    int inOffset;
    String vcfFile;
    String bedFile;

    public SnpSiftCmdIntervalsIndex() {
    }

    public SnpSiftCmdIntervalsIndex(String[] args) {
        super(args);
    }

    @Override
    public void init() {
        super.init();
        this.genome = new Genome("genome");
        this.listCommandLine = false;
        this.seqChanges = new ArrayList<Variant>();
        this.inOffset = 0;
        this.vcfFile = null;
        this.bedFile = null;
    }

    public void loadIntervals() {
        if (this.verbose) {
            Log.info("Reading BED file '" + this.bedFile + "'");
        }
        BedFileIterator bf = new BedFileIterator(this.bedFile, this.genome);
        bf.setCreateChromos(true);
        this.seqChanges = bf.load();
        Collections.sort(this.seqChanges);
        if (this.verbose) {
            Log.info("Total " + this.seqChanges.size() + " intervals added.");
        }
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (this.isOpt(args[i2])) {
                if (args[i2].equals("-if")) {
                    if (i2 + 1 >= args.length) continue;
                    this.inOffset = Gpr.parseIntSafe(args[++i2]);
                    continue;
                }
                if (!args[i2].equals("-i")) continue;
                this.listCommandLine = true;
                this.inOffset = 1;
                continue;
            }
            if (this.vcfFile == null) {
                this.vcfFile = args[i2];
                continue;
            }
            if (this.bedFile != null) continue;
            if (this.listCommandLine) {
                this.seqChanges.add(this.parsePos(args[i2]));
                continue;
            }
            this.bedFile = args[i2];
        }
        if (this.vcfFile == null) {
            this.usage("Missing BED file");
        }
        if (this.listCommandLine && this.seqChanges.size() <= 0) {
            this.usage("Missing intervals");
        }
        if (!this.listCommandLine && this.bedFile == null) {
            this.usage("Missing VCF file");
        }
    }

    Variant parsePos(String pos) {
        String[] recs = pos.split(":");
        if (recs.length != 2) {
            this.usage("Invalid interval '" + pos + "'. Format 'chr:start-end'");
        }
        String chr = recs[0];
        String[] p = recs[1].split("-");
        if (p.length != 2) {
            this.usage("Invalid interval '" + pos + "'. Format 'chr:start-end'");
        }
        int start = Gpr.parseIntSafe(p[0]) - this.inOffset;
        int end = Gpr.parseIntSafe(p[1]) - this.inOffset;
        Chromosome chromo = new Chromosome(this.genome, 0, 0, chr);
        return new Variant((Marker)chromo, start, end, "");
    }

    @Override
    public boolean run() {
        if (!this.listCommandLine) {
            this.loadIntervals();
        }
        VcfFileIterator vcfFileIt = new VcfFileIterator(this.vcfFile);
        vcfFileIt.setDebug(this.debug);
        vcfFileIt.iterator().next();
        this.addHeaders(vcfFileIt);
        String headerStr = vcfFileIt.getVcfHeader().toString();
        if (!headerStr.isEmpty()) {
            System.out.println(headerStr);
        }
        vcfFileIt.close();
        FileIndexChrPos fileIndexChrPos = new FileIndexChrPos(this.vcfFile);
        if (this.verbose) {
            Log.info("Indexing file '" + this.vcfFile + "'");
        }
        fileIndexChrPos.setVerbose(this.verbose);
        fileIndexChrPos.setDebug(this.debug);
        fileIndexChrPos.open();
        fileIndexChrPos.index();
        if (this.verbose) {
            Log.info("Done");
        }
        int scNum = 1;
        for (Variant sc : this.seqChanges) {
            try {
                if (this.verbose) {
                    Log.info(scNum + " / " + this.seqChanges.size() + "\t\tFinding interval: " + sc.getChromosomeName() + ":" + (sc.getStart() + 1) + "-" + (sc.getEnd() + 1));
                }
                fileIndexChrPos.dump(sc.getChromosomeName(), sc.getStart(), sc.getEnd(), false);
                ++scNum;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (this.verbose) {
            Log.info("Done");
        }
        return true;
    }

    public void setInOffset(int inOffset) {
        this.inOffset = inOffset;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar intidx [-if N] [-i] file.vcf ( file.bed | chr:start1-end1 chr:start2-end2 ... chr:startN-endN )");
        System.err.println("Option:");
        System.err.println("\t-if <N>   : Input offset. Default 0 (i.e. zero-based coordinates).");
        System.err.println("\t-i        : Genomic intervals in command line.");
        System.exit(1);
    }
}

