/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.interval.tree.IntervalForest;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;
import org.snpsift.SnpSift;
import org.snpsift.gwasCatalog.GwasCatalog;
import org.snpsift.gwasCatalog.GwasCatalogEntry;

public class SnpSiftCmdGwasCatalog
extends SnpSift {
    public static final int SHOW = 10000;
    public static final int SHOW_LINES = 1000000;
    public final String GWAS_CATALOG = "GWASCAT";
    public final String CONFIG_GWAS_DB_NAME = "gwascatalog";
    GwasCatalog gwasCatalog;
    IntervalForest intervalForest;

    public SnpSiftCmdGwasCatalog() {
    }

    public SnpSiftCmdGwasCatalog(String[] args) {
        super(args);
    }

    List<VcfEntry> annotate(boolean saveResults) {
        VcfFileIterator vcf = this.openVcfInputFile();
        vcf.setDebug(this.debug);
        this.annotateInit(vcf);
        int countAnnotated = 0;
        int count = 0;
        boolean showHeader = true;
        ArrayList<VcfEntry> vcfEntries = saveResults ? new ArrayList<VcfEntry>() : null;
        for (VcfEntry vcfEntry : vcf) {
            if (showHeader) {
                this.addHeaders(vcf);
                String headerStr = vcf.getVcfHeader().toString();
                if (!headerStr.isEmpty()) {
                    this.print(headerStr);
                }
                showHeader = false;
            }
            boolean annotated = this.annotate(vcfEntry);
            if (saveResults) {
                vcfEntries.add(vcfEntry);
            } else {
                this.print(vcfEntry);
            }
            if (annotated) {
                ++countAnnotated;
            }
            ++count;
        }
        this.annotateFinish(vcf);
        double perc = 100.0 * (double)countAnnotated / (double)count;
        if (this.verbose) {
            Log.info("Done.\n\tTotal annotated entries : " + countAnnotated + "\n\tTotal entries           : " + count + "\n\tPercent                 : " + String.format("%.2f%%", perc));
        }
        return vcfEntries;
    }

    @Override
    public boolean annotate(VcfEntry vcfEntry) {
        boolean annotated = false;
        for (Variant var : vcfEntry.variants()) {
            Markers results;
            if (!var.isVariant() || var.isStructuralHuge() || (results = this.intervalForest.query(var)).isEmpty()) continue;
            LinkedList<GwasCatalogEntry> resultsGwasCat = new LinkedList<GwasCatalogEntry>();
            for (Marker m : results) {
                String key = m.getId();
                List<GwasCatalogEntry> resultsKey = this.gwasCatalog.get(key);
                if (resultsKey == null) continue;
                resultsGwasCat.addAll(resultsKey);
            }
            this.vcfAnnotation(vcfEntry, resultsGwasCat);
            annotated = true;
        }
        return annotated;
    }

    @Override
    public boolean annotateFinish(VcfFileIterator vcfFile) {
        super.annotateFinish(vcfFile);
        return true;
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        if (this.dbFileName == null && this.config != null) {
            this.dbFileName = this.config.getDatabaseLocal("gwascatalog");
        }
        this.readDb();
        this.buildIntervalForest();
        return true;
    }

    void buildIntervalForest() {
        Genome genome = new Genome();
        Markers markers = new Markers();
        for (GwasCatalogEntry ge : this.gwasCatalog) {
            ge.chrId = Chromosome.simpleName(ge.chrId);
            int pos = ge.chrPos - 1;
            Chromosome chr = genome.getOrCreateChromosome(ge.chrId);
            String id = this.gwasCatalog.key(ge);
            Marker m = new Marker(chr, pos, pos, false, id);
            markers.add(m);
        }
        if (this.verbose) {
            Log.info("Creating interval tree for GWAS catalog");
        }
        this.intervalForest = new IntervalForest(markers);
        this.intervalForest.build();
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> newHeaders = super.headers();
        newHeaders.add(new VcfHeaderInfo("GWASCAT_TRAIT", VcfInfoType.String, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "GWAS catalog: Associated trait"));
        newHeaders.add(new VcfHeaderInfo("GWASCAT_P_VALUE", VcfInfoType.Float, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "GWAS catalog: p-value"));
        newHeaders.add(new VcfHeaderInfo("GWASCAT_OR_BETA", VcfInfoType.Float, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "GWAS catalog: OR or Beta"));
        newHeaders.add(new VcfHeaderInfo("GWASCAT_REPORTED_GENE", VcfInfoType.String, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "GWAS catalog: Reported gene"));
        newHeaders.add(new VcfHeaderInfo("GWASCAT_PUBMED_ID", VcfInfoType.String, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "GWAS catalog: Original paper's Pubmed ID"));
        return newHeaders;
    }

    @Override
    public void init() {
        super.init();
        this.needsConfig = true;
        this.needsDb = true;
        this.needsGenome = true;
        this.dbTabix = false;
        this.dbType = "gwascatalog";
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length < 1) {
            this.usage(null);
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg) && (arg.equals("-h") || arg.equals("-help"))) {
                this.usage(null);
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("VCF input file already assigned to '" + this.vcfInputFile + "'");
        }
    }

    public void readDb() {
        if (this.verbose) {
            Log.info("Loading database: '" + this.dbFileName + "'");
        }
        this.gwasCatalog = new GwasCatalog(this.dbFileName);
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean saveResults) {
        if (this.config == null) {
            this.loadConfig();
        }
        this.dbFileName = this.databaseFind();
        if (this.verbose) {
            Log.info("Annotating:\tInput file : '" + (this.vcfInputFile != null ? this.vcfInputFile : "STDIN") + "'\tDatabase file : '" + this.dbFileName + "'");
        }
        return this.annotate(saveResults);
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar gwasCat [-db path/to/gwascat.txt] [file.vcf] > newFile.vcf.");
        this.usageGenericAndDb();
        System.exit(1);
    }

    void vcfAnnotate(StringBuilder sb, String value) {
        if (sb.length() > 0) {
            sb.append(",");
        }
        if (value == null || value.isEmpty()) {
            value = ".";
        }
        sb.append(VcfEntry.vcfInfoValueSafe(value));
    }

    void vcfAnnotation(VcfEntry vcfEntry, List<GwasCatalogEntry> list) {
        new StringBuilder();
        StringBuilder sbPubmedId = new StringBuilder();
        StringBuilder sbTrait = new StringBuilder();
        StringBuilder sbReportedGene = new StringBuilder();
        StringBuilder sbPvalue = new StringBuilder();
        StringBuilder sbOr = new StringBuilder();
        for (GwasCatalogEntry ge : list) {
            this.vcfAnnotate(sbPubmedId, ge.pubmedId);
            this.vcfAnnotate(sbTrait, ge.trait);
            this.vcfAnnotate(sbReportedGene, ge.reportedGene);
            this.vcfAnnotate(sbPvalue, "" + ge.pValue);
            if (!(Gpr.parseDoubleSafe(ge.orBeta) > 0.0)) continue;
            this.vcfAnnotate(sbOr, ge.orBeta);
        }
        if (sbTrait.length() > 0) {
            vcfEntry.addInfo("GWASCAT_TRAIT", sbTrait.toString());
        }
        if (sbPvalue.length() > 0) {
            vcfEntry.addInfo("GWASCAT_P_VALUE", sbPvalue.toString());
        }
        if (sbOr.length() > 0) {
            vcfEntry.addInfo("GWASCAT_OR_BETA", sbOr.toString());
        }
        if (sbReportedGene.length() > 0) {
            vcfEntry.addInfo("GWASCAT_REPORTED_GENE", sbReportedGene.toString());
        }
        if (sbPubmedId.length() > 0) {
            vcfEntry.addInfo("GWASCAT_PUBMED_ID", sbPubmedId.toString());
        }
    }
}

