/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpsift.SnpSift;
import org.snpsift.lang.LangFactory;
import org.snpsift.lang.Value;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.expression.FieldIterator;

public class SnpSiftCmdFilterGt
extends SnpSift {
    boolean inverse;
    boolean exceptionIfNotFound;
    String expression;
    String gtFieldName;
    String gtFieldValue;
    Expression expr;
    String filterId;
    ArrayList<HashSet<String>> sets;
    EffFormatVersion formatVersion;

    public SnpSiftCmdFilterGt() {
    }

    public SnpSiftCmdFilterGt(String[] args) {
        super(args);
    }

    public void addSet(String fileName) {
        String file = Gpr.readFile(fileName);
        if (file.isEmpty()) {
            throw new RuntimeException("Could not read any entries from file '" + fileName + "'");
        }
        HashSet<String> set = new HashSet<String>();
        for (String str : file.split("\n")) {
            set.add(str.trim());
        }
        this.sets.add(set);
        if (this.verbose) {
            Log.info("Adding set '" + fileName + "', " + set.size() + " elements.");
        }
    }

    boolean evaluate(VcfEntry vcfEntry) {
        if (this.debug) {
            Log.debug(vcfEntry.toStringNoGt());
        }
        boolean ok = false;
        for (VcfGenotype vgt : vcfEntry) {
            boolean change = this.evaluate(vcfEntry, vgt);
            if (this.debug) {
                Log.debug("\t\tevaluate:" + change + "\t" + String.valueOf(vgt));
            }
            if (!change) continue;
            ok = true;
            vgt.set(this.gtFieldName, this.gtFieldValue);
        }
        if (this.debug && ok) {
            Log.debug("VCF entry changed:\t" + String.valueOf(vcfEntry));
        }
        return ok;
    }

    boolean evaluate(VcfEntry vcfEntry, VcfGenotype vcfGenotype) {
        FieldIterator fieldIterator = FieldIterator.get();
        fieldIterator.reset();
        boolean all = true;
        boolean any = false;
        if (this.debug) {
            Log.debug("VCF entry:" + vcfEntry.toStringNoGt() + "\t" + String.valueOf(vcfGenotype));
        }
        while (true) {
            Value eval = this.expr.eval(vcfGenotype);
            if (this.debug) {
                Log.debug("\tEval: " + String.valueOf(eval) + "\tFieldIterator: " + String.valueOf(fieldIterator));
            }
            any |= eval.asBool();
            if (fieldIterator.getType() == -2 && !(all &= eval.asBool())) {
                boolean ret = this.inverse ^ all;
                if (this.debug) {
                    Log.debug("\tResult [ALL]: " + ret);
                }
                return ret;
            }
            if (fieldIterator.getType() == -1 && any) {
                boolean ret = this.inverse ^ any;
                if (this.debug) {
                    Log.debug("\tResult [ANY]: " + ret);
                }
                return ret;
            }
            if (!fieldIterator.hasNext()) break;
            fieldIterator.next();
        }
        boolean ret = false;
        if (fieldIterator.getType() == -2) {
            ret = all;
            if (this.debug) {
                Log.debug("\tResult [ALL]: " + ret);
            }
        } else {
            ret = any;
            if (this.debug) {
                Log.debug("\tResult [ANY]: " + ret);
            }
        }
        ret = this.inverse ^ ret;
        if (this.debug && this.inverse) {
            Log.debug("\tResult [INV]: " + ret);
        }
        return ret;
    }

    public List<VcfEntry> filter(String fileName, String expression, boolean createList) {
        this.vcfInputFile = fileName;
        this.expression = expression;
        return this.run(createList);
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> addHeader = super.headers();
        String expr = this.expression.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim();
        if (!this.filterId.isEmpty()) {
            addHeader.add(new VcfHeaderEntry("##FILTER=<ID=" + this.filterId + ",Description=\"" + VERSION_NO_NAME + ", Expression used: " + expr + "\">"));
        }
        return addHeader;
    }

    @Override
    public void init() {
        super.init();
        this.verbose = false;
        this.inverse = false;
        this.vcfInputFile = null;
        this.filterId = SnpSift.class.getSimpleName();
        this.sets = new ArrayList();
        this.formatVersion = null;
        this.exceptionIfNotFound = false;
        this.gtFieldName = "GT";
        this.gtFieldValue = ".";
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-h": 
                    case "-help": {
                        this.usage(null);
                        break;
                    }
                    case "-f": 
                    case "--file": {
                        this.vcfInputFile = args[++i2];
                        break;
                    }
                    case "-s": 
                    case "--set": {
                        this.addSet(args[++i2]);
                        break;
                    }
                    case "--errmissing": {
                        this.exceptionIfNotFound = true;
                        break;
                    }
                    case "-n": 
                    case "--inverse": {
                        this.inverse = true;
                        break;
                    }
                    case "-gn": 
                    case "--field": {
                        this.gtFieldName = args[++i2];
                        break;
                    }
                    case "-gv": 
                    case "--value": {
                        this.gtFieldValue = args[++i2];
                        break;
                    }
                    case "--format": {
                        String formatVer = args[++i2];
                        if (formatVer.equals("2")) {
                            this.formatVersion = EffFormatVersion.FORMAT_EFF_2;
                            break;
                        }
                        if (formatVer.equals("3")) {
                            this.formatVersion = EffFormatVersion.FORMAT_EFF_3;
                            break;
                        }
                        this.usage("Unknown format version '" + formatVer + "'");
                        break;
                    }
                    case "-e": 
                    case "--exprfile": {
                        String exprFile = args[++i2];
                        if (this.verbose) {
                            Log.info("Reading expression from file '" + exprFile + "'");
                        }
                        this.expression = Gpr.readFile(exprFile);
                        break;
                    }
                    default: {
                        this.usage("Unknown option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.expression == null) {
                this.expression = arg;
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.expression == null) {
            this.usage("Missing filter expression!");
        }
        if (this.vcfInputFile == null) {
            this.vcfInputFile = "-";
        }
    }

    public Expression parseExpression(String expression) throws Exception {
        if (this.debug) {
            Log.debug("Parse expression: \"" + expression + "\"");
        }
        LangFactory lf = new LangFactory();
        this.expr = lf.compile(expression);
        if (this.expr == null) {
            System.err.println("Fatal error: Cannot build expression tree.");
            System.exit(-1);
        }
        if (this.debug) {
            Log.debug("Expression: " + String.valueOf(this.expr));
        }
        return this.expr;
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        if (this.debug) {
            Expression.debug = true;
        }
        try {
            this.parseExpression(this.expression);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.usage("Error parsing expression: '" + this.expression + "'");
        }
        LinkedList<VcfEntry> passEntries = createList ? new LinkedList<VcfEntry>() : null;
        VcfFileIterator vcfFile = this.openVcfInputFile();
        this.annotateInit(vcfFile);
        this.showVcfHeader = !createList;
        for (VcfEntry vcfEntry : vcfFile) {
            this.processVcfHeader(vcfFile);
            this.evaluate(vcfEntry);
            if (passEntries != null) {
                passEntries.add(vcfEntry);
                continue;
            }
            System.out.println(vcfEntry);
        }
        this.annotateFinish(vcfFile);
        return passEntries;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.out.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar filter [options] 'expression' [input.vcf]");
        System.err.println("Options:");
        System.err.println("\t-e  | --exprFile <file>    : Read expression from a file");
        System.err.println("\t-f  | --file <input.vcf>   : VCF input file. Default: STDIN");
        System.err.println("\t-gn | --field <name>       : Field name to replace if filter is true. Default: '" + this.gtFieldName + "'");
        System.err.println("\t-gv | --value <value>      : Field value to replace if filter is true. Default: '" + this.gtFieldValue + "'");
        System.err.println("\t-n  | --inverse            : Inverse. Show lines that do not match filter expression");
        System.err.println("\t-s  | --set <file>         : Create a SET using 'file'");
        System.err.println("\t--errMissing               : Error is a field is missing. Default: " + this.exceptionIfNotFound);
        System.err.println("\t--format <format>          : SnpEff format version: {2, 3}. Default: " + String.valueOf(this.formatVersion == null ? "Auto" : this.formatVersion));
        System.exit(-1);
    }
}

