/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import gnu.trove.set.hash.TIntHashSet;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.collections.AutoHashMap;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.SnpSift;

public class SnpSiftCmdFilterChrPos
extends SnpSift {
    AutoHashMap<String, TIntHashSet> chrpos = new AutoHashMap(new TIntHashSet());
    String chrPosFile;
    int countChrPosLines = 0;
    int countChrPosAdded = 0;
    int countVcfFiltered = 0;

    public SnpSiftCmdFilterChrPos() {
    }

    public SnpSiftCmdFilterChrPos(String[] args) {
        super(args);
    }

    protected boolean filter(VcfEntry vcfEntry) {
        return this.hasPos(vcfEntry.getChromosomeName(), vcfEntry.getStart());
    }

    boolean hasPos(String chr, int pos) {
        TIntHashSet posSet = (TIntHashSet)this.chrpos.get(chr);
        if (posSet == null) {
            return false;
        }
        return posSet.contains(pos);
    }

    void loadChrPos() {
        if (this.verbose) {
            Log.info("Reading 'chr:pos' from file '" + this.chrPosFile + "'.");
        }
        LineFileIterator lfi = new LineFileIterator(this.chrPosFile);
        for (String line : lfi) {
            ++this.countChrPosLines;
            if (line.startsWith("#")) continue;
            String[] fields = line.split("\t", 3);
            String chr = fields[0];
            int pos = Gpr.parseIntSafe(fields[1]);
            if (pos <= 0 || !this.chrpos.getOrCreate(chr = Chromosome.simpleName(chr)).add(--pos)) continue;
            ++this.countChrPosAdded;
        }
        if (this.verbose) {
            Log.info("Done.\n\t\tLines         : " + this.countChrPosLines + "\n\t\tEntries added : " + this.countChrPosAdded);
        }
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) continue;
            if (this.chrPosFile == null) {
                this.chrPosFile = arg;
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.chrPosFile == null) {
            this.usage("No chrpos.txt file provided.");
        }
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        LinkedList<VcfEntry> passEntries = createList ? new LinkedList<VcfEntry>() : null;
        this.loadChrPos();
        this.showVcfHeader = !createList;
        VcfFileIterator vcfFile = this.openVcfInputFile();
        this.annotateInit(vcfFile);
        int countVcfLines = 0;
        for (VcfEntry vcfEntry : vcfFile) {
            ++countVcfLines;
            this.processVcfHeader(vcfFile);
            if (this.filter(vcfEntry)) {
                this.print(vcfEntry);
                ++this.countVcfFiltered;
                if (passEntries != null) {
                    passEntries.add(vcfEntry);
                }
            }
            if (!this.verbose) continue;
            Gpr.showMark(countVcfLines, SHOW_EVERY_VCFLINES);
        }
        this.annotateFinish(vcfFile);
        if (this.verbose) {
            Log.info("Done filtering.\n\t\tVCF lines                : " + countVcfLines + "\n\t\tVCF lines passing filter : " + this.countVcfFiltered + "\n\t\tChrPos lines             : " + this.countChrPosLines + "\n\t\tChrPos entries added     : " + this.countChrPosAdded);
        }
        return passEntries;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.out.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar filter [options] chrpos.txt [input.vcf]");
        System.err.println("\nFile 'chrpos.txt' is parsed as follows:");
        System.err.println("\t- First two (tab-separated) columns are 'chr' and 'pos'.");
        System.err.println("\t- Other columns are ignored.");
        System.err.println("\t- Lines starting with '#' are ignored.");
        System.err.println("\t- Positions are one-based (same as in VCF files).");
        System.exit(-1);
    }
}

