/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import org.snpeff.fileIterator.MatrixEntry;
import org.snpeff.fileIterator.MatrixEntryFileIterator;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpsift.SnpSift;

public class SnpSiftCmdCovarianceMatrix
extends SnpSift {
    public static int SHOW_EVERY = 10000;
    String matrixFile;
    double[] mean;
    double[][] matrix;

    public SnpSiftCmdCovarianceMatrix() {
    }

    public SnpSiftCmdCovarianceMatrix(String[] args) {
        super(args);
    }

    public void covariance() {
        int i2;
        int len = this.mean.length;
        this.matrix = new double[len][len];
        for (int i3 = 0; i3 < len; ++i3) {
            for (int j = 0; j < len; ++j) {
                this.matrix[i3][j] = 0.0;
            }
        }
        int count = 0;
        int lineNum = 1;
        MatrixEntryFileIterator mfile = new MatrixEntryFileIterator(this.matrixFile);
        for (MatrixEntry m : mfile) {
            int[] scores = m.getValues();
            for (int i4 = 0; i4 < len; ++i4) {
                for (int j = i4; j < len; ++j) {
                    double[] dArray = this.matrix[i4];
                    int n = j;
                    dArray[n] = dArray[n] + ((double)scores[i4] - this.mean[i4]) * ((double)scores[j] - this.mean[j]);
                }
            }
            Gpr.showMark(lineNum++, SHOW_EVERY);
            ++count;
        }
        for (i2 = 0; i2 < len; ++i2) {
            for (int j = i2 + 1; j < len; ++j) {
                this.matrix[j][i2] = this.matrix[i2][j];
            }
        }
        if (count > 0) {
            for (i2 = 0; i2 < len; ++i2) {
                for (int j = 0; j < len; ++j) {
                    double[] dArray = this.matrix[j];
                    int n = i2;
                    dArray[n] = dArray[n] / (double)count;
                }
            }
        }
        for (i2 = 0; i2 < len; ++i2) {
            double p = this.mean[i2] / 2.0;
            double sigma = Math.sqrt(p * (1.0 - p));
            if (sigma == 0.0) {
                throw new RuntimeException("Sigma is zero for column " + i2 + " (mean = " + this.mean[i2] + "). This should never happen!");
            }
            for (int j = 0; j < len; ++j) {
                double[] dArray = this.matrix[j];
                int n = i2;
                dArray[n] = dArray[n] / sigma;
            }
        }
    }

    public void mean() {
        long[] sum = null;
        int count = 0;
        int lineNum = 1;
        MatrixEntryFileIterator mfile = new MatrixEntryFileIterator(this.matrixFile);
        for (MatrixEntry m : mfile) {
            int[] scores = m.getValues();
            if (sum == null) {
                sum = new long[scores.length];
            }
            for (int i2 = 0; i2 < scores.length; ++i2) {
                int n = i2;
                sum[n] = sum[n] + (long)scores[i2];
            }
            Gpr.showMark(lineNum++, SHOW_EVERY);
            ++count;
        }
        this.mean = new double[sum.length];
        if (count > 0) {
            for (int i3 = 0; i3 < this.mean.length; ++i3) {
                this.mean[i3] = (double)sum[i3] / (double)count;
            }
        }
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length != 1) {
            this.usage(null);
        }
        this.matrixFile = args[0];
    }

    @Override
    public boolean run() {
        Log.info("Pass1: Processing file '" + this.matrixFile + "'");
        this.mean();
        Log.info("Pass2: Processing file '" + this.matrixFile + "'");
        this.covariance();
        System.out.println(this);
        Log.info("Done");
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.matrix.length; ++i2) {
            String sep = "";
            for (int j = 0; j < this.matrix[i2].length; ++j) {
                sb.append(sep + this.matrix[i2][j]);
                sep = "\t";
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar covMat allele.matrix.txt > cov.matrix.txt");
        System.exit(1);
    }
}

