/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.ped.PedPedigree;
import org.snpeff.ped.TfamEntry;
import org.snpeff.probablility.CochranArmitageTest;
import org.snpeff.probablility.FisherExactTest;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpsift.SnpSift;

public class SnpSiftCmdCaseControl
extends SnpSift {
    public static final int SHOW_EVERY = 100;
    public static final String VCF_INFO_CASE = "Cases";
    public static final String VCF_INFO_CONTROL = "Controls";
    public static final String VCF_INFO_CC_GENO = "CC_GENO";
    public static final String VCF_INFO_CC_ALL = "CC_ALL";
    public static final String VCF_INFO_CC_DOM = "CC_DOM";
    public static final String VCF_INFO_CC_REC = "CC_REC";
    public static final String VCF_INFO_CC_TREND = "CC_TREND";
    protected Boolean[] caseControl;
    protected String tfamFile;
    protected String groups;
    protected PedPedigree pedigree;
    protected double pvalueThreshold;
    protected boolean useChiSquare;
    String name;
    String posMin = "";
    double pValueMin = 1.0;

    public SnpSiftCmdCaseControl() {
    }

    public SnpSiftCmdCaseControl(String[] args) {
        super(args);
    }

    @Override
    public boolean annotate(VcfEntry vcfEntry) {
        int casesHom = 0;
        int casesHet = 0;
        int cases = 0;
        int ctrlHom = 0;
        int ctrlHet = 0;
        int ctrl = 0;
        int[] nCase = new int[3];
        int[] nControl = new int[3];
        int idx = 0;
        if (this.debug) {
            Log.debug(vcfEntry.toStringNoGt());
        }
        for (VcfGenotype gt : vcfEntry) {
            int code = gt.getGenotypeCode();
            if (this.caseControl[idx] != null) {
                int codeMissing = gt.getGenotypeCodeIgnoreMissing();
                if (code >= 0) {
                    if (this.caseControl[idx].booleanValue()) {
                        int n = code;
                        nCase[n] = nCase[n] + 1;
                    } else {
                        int n = code;
                        nControl[n] = nControl[n] + 1;
                    }
                }
                if (gt.isVariant()) {
                    if (this.caseControl[idx].booleanValue()) {
                        if (!gt.isMissing()) {
                            if (gt.isHomozygous()) {
                                ++casesHom;
                            } else {
                                ++casesHet;
                            }
                        }
                        cases += codeMissing;
                    } else {
                        if (!gt.isMissing()) {
                            if (gt.isHomozygous()) {
                                ++ctrlHom;
                            } else {
                                ++ctrlHet;
                            }
                        }
                        ctrl += codeMissing;
                    }
                }
            }
            if (this.debug) {
                String cc = "Ignore";
                if (this.caseControl[idx] != null) {
                    cc = this.caseControl[idx] != false ? "Case" : "Control";
                }
                System.err.printf("\tSample: %3d\tType: %-8s\tGT code: %+1d\tnCases: [%3d, %3d, %3d]\tnControls: [%3d, %3d, %3d]\tGT: %s\n", idx, cc, code, nCase[0], nCase[1], nCase[2], nControl[0], nControl[1], nControl[2], gt);
            }
            ++idx;
        }
        vcfEntry.addInfo(VCF_INFO_CASE + this.name, casesHom + "," + casesHet + "," + cases);
        vcfEntry.addInfo(VCF_INFO_CONTROL + this.name, ctrlHom + "," + ctrlHet + "," + ctrl);
        vcfEntry.addInfo(VCF_INFO_CC_TREND + this.name, this.pValueStr(vcfEntry, this.pTrend(nControl, nCase)));
        vcfEntry.addInfo(VCF_INFO_CC_GENO + this.name, this.pValueStr(vcfEntry, this.pGenotypic(nControl, nCase)));
        this.swapMinorAllele(nControl, nCase);
        vcfEntry.addInfo(VCF_INFO_CC_ALL + this.name, this.pValueStr(vcfEntry, this.pAllelic(nControl, nCase, this.pvalueThreshold)));
        vcfEntry.addInfo(VCF_INFO_CC_DOM + this.name, this.pValueStr(vcfEntry, this.pDominant(nControl, nCase, this.pvalueThreshold)));
        vcfEntry.addInfo(VCF_INFO_CC_REC + this.name, this.pValueStr(vcfEntry, this.pRecessive(nControl, nCase, this.pvalueThreshold)));
        return true;
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> addh = super.headers();
        addh.add(new VcfHeaderEntry("##INFO=<ID=Cases" + this.name + ",Number=3,Type=Integer,Description=\"Number of variants in cases: Hom, Het, Count\">"));
        addh.add(new VcfHeaderEntry("##INFO=<ID=Controls" + this.name + ",Number=3,Type=Integer,Description=\"Number of variants in controls: Hom, Het, Count\">"));
        addh.add(new VcfHeaderEntry("##INFO=<ID=CC_DOM" + this.name + ",Number=1,Type=Float,Description=\"p-value using dominant model (Fisher exact test)\">"));
        addh.add(new VcfHeaderEntry("##INFO=<ID=CC_REC" + this.name + ",Number=1,Type=Float,Description=\"p-value using recessive model (Fisher exact test)\">"));
        addh.add(new VcfHeaderEntry("##INFO=<ID=CC_ALL" + this.name + ",Number=1,Type=Float,Description=\"p-value using allele count model (Fisher exact test)\">"));
        addh.add(new VcfHeaderEntry("##INFO=<ID=CC_GENO" + this.name + ",Number=1,Type=Float,Description=\"p-value using genotypic model (ChiSquare)\">"));
        addh.add(new VcfHeaderEntry("##INFO=<ID=CC_TREND" + this.name + ",Number=1,Type=Float,Description=\"p-value using trend model (CochranArmitage)\">"));
        return addh;
    }

    @Override
    public void init() {
        super.init();
        this.pvalueThreshold = 1.0;
        this.useChiSquare = false;
    }

    boolean isGroupString(String groupsStr) {
        return groupsStr.replace('+', ' ').replace('-', ' ').replace('0', ' ').trim().isEmpty();
    }

    protected double pAllelic(int[] nControl, int[] nCase, double pvalueTh) {
        int k = 2 * nCase[2] + nCase[1];
        int N = 2 * (nControl[0] + nControl[1] + nControl[2] + nCase[0] + nCase[1] + nCase[2]);
        int D = 2 * (nCase[0] + nCase[1] + nCase[2]);
        int n = 2 * nControl[2] + nControl[1] + 2 * nCase[2] + nCase[1];
        if (this.useChiSquare) {
            return FisherExactTest.get().chiSquareApproximation(k, N, D, n);
        }
        double pdown = FisherExactTest.get().pValueDown(k, N, D, n, pvalueTh);
        double pup = FisherExactTest.get().pValueUp(k, N, D, n, pvalueTh);
        double pvalue = Math.min(pup, pdown);
        if (this.debug) {
            Log.debug("pAllelic: " + pvalue + "\tFisherExactTest.pValueDown(" + k + ", " + N + ", " + D + ", " + n + ", " + pvalueTh + "): " + pdown + "\tR: " + FisherExactTest.get().toR(k, N, D, n, true) + "\tFisherExactTest.pValueUp(" + k + ", " + N + ", " + D + ", " + n + ", " + pvalueTh + "): " + pup + "\tR: " + FisherExactTest.get().toR(k - 1, N, D, n, false));
        }
        return pvalue;
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length <= 0) {
            this.usage(null);
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                if (arg.equals("-tfam")) {
                    this.tfamFile = args[++i2];
                    continue;
                }
                if (arg.equals("-name")) {
                    this.name = args[++i2];
                    continue;
                }
                if (arg.equals("-chi2")) {
                    this.useChiSquare = true;
                    continue;
                }
                if (this.groups != null || this.tfamFile != null || !this.isGroupString(arg)) continue;
                this.groups = arg;
                continue;
            }
            if (this.groups == null && this.tfamFile == null && this.isGroupString(arg)) {
                this.groups = arg;
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("Unkown parameter '" + arg + "'");
        }
        if (this.groups == null && this.tfamFile == null) {
            this.usage("You must provide either a 'group' string or a TFAM file");
        }
        if (this.name == null) {
            this.name = "";
        }
    }

    void parseCaseControlString() {
        char[] chars = this.groups.toCharArray();
        this.caseControl = new Boolean[chars.length];
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (chars[i2] == '+') {
                this.caseControl[i2] = true;
                continue;
            }
            if (chars[i2] == '-') {
                this.caseControl[i2] = false;
                continue;
            }
            if (chars[i2] == '0') {
                this.caseControl[i2] = null;
                continue;
            }
            this.usage("Unknown character '" + chars[i2] + "' (sample " + (i2 + 1) + ") in groups string");
        }
    }

    void parseCaseControlTfam() {
        this.pedigree = new PedPedigree(this.tfamFile);
    }

    protected double pDominant(int[] nControl, int[] nCase, double pvalueTh) {
        int k = nCase[2] + nCase[1];
        int N = nControl[0] + nControl[1] + nControl[2] + nCase[0] + nCase[1] + nCase[2];
        int D = nCase[0] + nCase[1] + nCase[2];
        int n = nControl[2] + nControl[1] + nCase[2] + nCase[1];
        if (this.useChiSquare) {
            return FisherExactTest.get().chiSquareApproximation(k, N, D, n);
        }
        double pdown = FisherExactTest.get().pValueDown(k, N, D, n, pvalueTh);
        double pup = FisherExactTest.get().pValueUp(k, N, D, n, pvalueTh);
        double pvalue = Math.min(pup, pdown);
        if (this.debug) {
            Log.debug("pDominant: " + pvalue + "\tFisherExactTest.pValueDown(" + k + ", " + N + ", " + D + ", " + n + ", " + pvalueTh + "): " + pdown + "\tR: " + FisherExactTest.get().toR(k, N, D, n, true) + "\tFisherExactTest.pValueUp(" + k + ", " + N + ", " + D + ", " + n + ", " + pvalueTh + "): " + pup + "\tR: " + FisherExactTest.get().toR(k, N, D, n, false));
        }
        return pvalue;
    }

    protected double pGenotypic(int[] nControl, int[] nCase) {
        int i2;
        int rows = 2;
        int cols = 3;
        int[][] n = new int[rows][cols];
        for (int j = 0; j < cols; ++j) {
            n[0][j] = nCase[j];
            n[1][j] = nControl[j];
        }
        int total = 0;
        int[] totalRow = new int[2];
        int[] totalCol = new int[3];
        for (i2 = 0; i2 < rows; ++i2) {
            totalRow[i2] = 0;
        }
        for (int j = 0; j < cols; ++j) {
            totalCol[j] = 0;
        }
        for (i2 = 0; i2 < rows; ++i2) {
            for (int j = 0; j < cols; ++j) {
                int n2 = i2;
                totalRow[n2] = totalRow[n2] + n[i2][j];
                int n3 = j;
                totalCol[n3] = totalCol[n3] + n[i2][j];
                total += n[i2][j];
            }
        }
        double chi2 = 0.0;
        for (int i3 = 0; i3 < rows; ++i3) {
            for (int j = 0; j < cols; ++j) {
                double eij = (double)(totalCol[j] * totalRow[i3]) / (double)total;
                double diff = (double)n[i3][j] - eij;
                chi2 += diff * diff / eij;
            }
        }
        double oneMinusPvalue = new ChiSquaredDistribution(2.0).cumulativeProbability(chi2);
        double pvalue = 1.0 - oneMinusPvalue;
        if (this.debug) {
            Log.debug("pGenotypic: " + pvalue + "\tChiSquaredDistribution(2).cumulativeProbability(chi2): " + oneMinusPvalue);
        }
        return pvalue;
    }

    protected double pRecessive(int[] nControl, int[] nCase, double pvalueTh) {
        int k = nCase[2];
        int N = nControl[0] + nControl[1] + nControl[2] + nCase[0] + nCase[1] + nCase[2];
        int D = nCase[0] + nCase[1] + nCase[2];
        int n = nControl[2] + nCase[2];
        if (this.useChiSquare) {
            return FisherExactTest.get().chiSquareApproximation(k, N, D, n);
        }
        double pdown = FisherExactTest.get().pValueDown(k, N, D, n, pvalueTh);
        double pup = FisherExactTest.get().pValueUp(k, N, D, n, pvalueTh);
        double pvalue = Math.min(pup, pdown);
        if (this.debug) {
            Log.debug("pRecessive: " + pvalue + "\tFisherExactTest.pValueDown(" + k + ", " + N + ", " + D + ", " + n + ", " + pvalueTh + "): " + pdown + "\tR: " + FisherExactTest.get().toR(k, N, D, n, true) + "\tFisherExactTest.pValueUp(" + k + ", " + N + ", " + D + ", " + n + ", " + pvalueTh + "): " + pup + "\tR: " + FisherExactTest.get().toR(k, N, D, n, false));
        }
        return pvalue;
    }

    @Override
    protected String processVcfHeader(VcfFileIterator vcf) {
        if (!vcf.isHeadeSection()) {
            return "";
        }
        String header = super.processVcfHeader(vcf);
        if (this.pedigree != null) {
            List<String> sampleIds = vcf.getVcfHeader().getSampleNames();
            this.caseControl = new Boolean[sampleIds.size()];
            int idx = 0;
            int errors = 0;
            for (String sid : sampleIds) {
                TfamEntry tfam = this.pedigree.get(sid);
                if (tfam == null) {
                    System.err.println("WARNING: Sample ID '" + sid + "' has no entry in pedigree form TFAM file '" + this.tfamFile + "'");
                    ++errors;
                    this.caseControl[idx] = null;
                } else {
                    this.caseControl[idx] = tfam.isMissing() ? null : Boolean.valueOf(tfam.isCase());
                }
                ++idx;
            }
            if (errors > sampleIds.size() / 2) {
                throw new RuntimeException("VCF samples are missing in TFAM file. Too many errors, aboting!");
            }
        }
        if (this.caseControl.length != vcf.getVcfHeader().getSampleNames().size()) {
            throw new RuntimeException("Number of case control entries specified does not match number of samples in VCF file");
        }
        if (this.debug) {
            System.err.println("\tSample\tCase");
            int idx = 0;
            for (String sid : vcf.getVcfHeader().getSampleNames()) {
                System.err.println("\t" + sid + "\t" + this.caseControl[idx++]);
            }
        }
        if (this.verbose) {
            int countCase = 0;
            int countCtrl = 0;
            int countIgnored = 0;
            for (Boolean cc : this.caseControl) {
                if (cc == null) {
                    ++countIgnored;
                    continue;
                }
                if (cc.booleanValue()) {
                    ++countCase;
                    continue;
                }
                ++countCtrl;
            }
            Log.info("Total : " + this.caseControl.length + " entries. Cases: " + countCase + ", controls: " + countCtrl + ", ignored: " + countIgnored);
        }
        return header;
    }

    protected double pTrend(int[] nControl, int[] nCase) {
        double pvalue = CochranArmitageTest.get().p(nControl, nCase, CochranArmitageTest.WEIGHT_TREND);
        if (this.debug) {
            Log.debug("CochranArmitageTest.p(" + Gpr.toString(nControl) + ", " + Gpr.toString(nCase) + ", " + Gpr.toString(CochranArmitageTest.WEIGHT_TREND) + ") = " + pvalue);
        }
        return Math.min(2.0 * pvalue, 1.0);
    }

    String pValueStr(VcfEntry vcfEntry, double p) {
        if (this.verbose && p > 0.0 && p < 1.0 && p <= this.pValueMin) {
            Log.info("Minimum p-value so far: " + this.pValueMin + "\tchr: " + vcfEntry.getChromosomeName() + "\tpos: " + (vcfEntry.getStart() + 1) + (String)(!vcfEntry.getId().isEmpty() ? "\tid: " + vcfEntry.getId() : ""));
        }
        if (p > 0.0 && p < this.pValueMin) {
            this.pValueMin = p;
            this.posMin = vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1);
        }
        return String.format("%.3e", p);
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        this.showVcfHeader = !createList;
        ArrayList<VcfEntry> list = new ArrayList<VcfEntry>();
        if (this.tfamFile != null) {
            this.parseCaseControlTfam();
        } else {
            this.parseCaseControlString();
        }
        VcfFileIterator vcf = this.openVcfInputFile();
        vcf.setDebug(this.debug);
        int i2 = 1;
        for (VcfEntry vcfEntry : vcf) {
            this.processVcfHeader(vcf);
            this.annotate(vcfEntry);
            if (createList) {
                list.add(vcfEntry);
            } else {
                System.out.println(vcfEntry);
            }
            if (!this.verbose) continue;
            Gpr.showMark(i2++, 100);
        }
        if (this.verbose) {
            Log.info("Done.\n\tMinimum pValue: " + this.pValueMin + "\tVcf entry: " + this.posMin);
        }
        return list;
    }

    protected void swapMinorAllele(int[] nControl, int[] nCase) {
        int refCount = 2 * nControl[0] + nControl[1] + 2 * nCase[0] + nCase[1];
        int altCount = 2 * nControl[2] + nControl[1] + 2 * nCase[2] + nCase[1];
        if (refCount < altCount) {
            if (this.debug) {
                Log.debug("Swapping genotype counts:\trefCount=" + refCount + "\taltCount=" + altCount);
            }
            int tmp = nControl[0];
            nControl[0] = nControl[2];
            nControl[2] = tmp;
            tmp = nCase[0];
            nCase[0] = nCase[2];
            nCase[2] = tmp;
        }
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar caseControl [-v] [-name nameString] { -tfam file.tfam | <CaseControlString> } file.vcf");
        System.err.println("Where:");
        System.err.println("\t<CaseControlString> : A string of {'+', '-', '0'}, one per sample, to identify two groups (case='+', control='-', neutral='0')");
        System.err.println("\t -chi2              : Use ChiSquare approximarion instead of Fisher exact test.");
        System.err.println("\t -name nameStr      : A name to be added after to 'Cases' or 'Controls' tags");
        System.err.println("\t -tfam file.tfam    : A TFAM file having case/control informations (phenotype colmun)");
        System.err.println("\tfile.vcf            : A VCF file (variants and genotype data)");
        System.exit(1);
    }
}

