/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpsift.SnpSift;
import org.snpsift.annotate.mem.database.VariantDatabase;
import org.snpsift.util.ShowProgress;

public class SnpSiftCmdAnnotateDf
extends SnpSift {
    boolean addAnnotated;
    boolean create;
    boolean emptyIfNotFound;
    List<String> dbFileNames;
    List<VariantDatabase> variantDatabases;
    Map<String, String[]> dbfile2fields;
    Map<String, String> dbfile2prefix;
    int found = 0;
    int countVcfEntries = 0;
    int annotationsAdded = 0;
    ShowProgress progress;

    public SnpSiftCmdAnnotateDf() {
    }

    public SnpSiftCmdAnnotateDf(String[] args) {
        super(args);
    }

    public void add(String dbFileName) {
        if (!this.dbFileNames.contains(dbFileName)) {
            this.dbFileNames.add(dbFileName);
        }
    }

    ArrayList<VcfEntry> annotate(boolean createList) {
        ArrayList<VcfEntry> list;
        ArrayList<VcfEntry> arrayList = list = createList ? new ArrayList<VcfEntry>() : null;
        if (this.verbose) {
            Log.info("Annotating entries from: '" + this.vcfInputFile + "'");
        }
        VcfFileIterator vcfFile = this.openVcfInputFile();
        try {
            this.annotateInit(vcfFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int pos = -1;
        String chr = "";
        for (VcfEntry vcfEntry : vcfFile) {
            try {
                this.processVcfHeader(vcfFile);
                if (vcfEntry.getChromosomeName().equals(chr) && vcfEntry.getStart() < pos) {
                    Log.error("VCF input file is not sorted!\n\tPrevious entry " + chr + ":" + pos + "\n\tCurrent entry  " + vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1));
                }
                this.annotate(vcfEntry);
                if (!this.suppressOutput) {
                    this.print(vcfEntry);
                }
                if (list != null) {
                    list.add(vcfEntry);
                }
                chr = vcfEntry.getChromosomeName();
                pos = vcfEntry.getStart();
            }
            catch (Exception e) {
                Log.error("Error while processing VCF entry: " + String.valueOf(vcfEntry));
                e.printStackTrace();
            }
        }
        this.annotateFinish(vcfFile);
        return list;
    }

    @Override
    public boolean annotate(VcfEntry vcfEntry) {
        int annotations = 0;
        for (VariantDatabase variantDatabase : this.variantDatabases) {
            annotations += variantDatabase.annotate(vcfEntry);
        }
        if (this.addAnnotated) {
            vcfEntry.addInfo("ANNOTATED", "");
        }
        ++this.countVcfEntries;
        this.annotationsAdded += annotations;
        if (annotations > 0) {
            ++this.found;
        }
        this.progress.tick(this.countVcfEntries, vcfEntry);
        return annotations > 0;
    }

    public boolean annotateFinish() {
        double foundPerc = 100.0 * (double)this.found / (double)this.countVcfEntries;
        Log.info("Done. Processed: " + String.format("%,d", this.countVcfEntries) + " VCF entries, found annotations for " + String.format("%,d", this.found) + String.format(" ( %.1f %% )", foundPerc) + ", added " + String.format("%,d", this.annotationsAdded) + " annotations., elapsed time: " + this.progress.elapsedSec());
        return true;
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        this.progress = new ShowProgress();
        this.variantDatabases = new ArrayList<VariantDatabase>();
        for (String dbFile : this.dbFileNames) {
            String dbDir = VariantDatabase.dbDirFromVcfFileName(dbFile);
            File dbDirFile = new File(dbDir);
            if (!dbDirFile.exists()) {
                Log.fatalError("Database directory does not exists: '" + dbDir + "'");
            }
            if (dbDirFile.list().length <= 0) {
                Log.fatalError("Database directory is empty '" + dbDir + "'");
            }
            String[] fieldNames = this.dbfile2fields.get(dbFile);
            String prefix = this.dbfile2prefix.get(dbFile);
            VariantDatabase variantDb = new VariantDatabase(dbFile, dbDir, fieldNames, prefix, this.emptyIfNotFound);
            variantDb.setVerbose(this.verbose);
            variantDb.load();
            if (fieldNames != null) {
                variantDb.checkFields(fieldNames, true);
            }
            this.variantDatabases.add(variantDb);
        }
        return true;
    }

    public void create() {
        Log.info("Create databases. " + this.dbFileNames.size() + " databases to create: " + String.valueOf(this.dbFileNames));
        for (String dbFileName : this.dbFileNames) {
            String dbDir = VariantDatabase.dbDirFromVcfFileName(dbFileName);
            File dbDirFile = new File(dbDir);
            if (dbDirFile.exists() && dbDirFile.list().length > 0) {
                Log.fatalError("Create database: Database directory already exists and it's non-empty: '" + dbDir + "'. Please remove it first.");
            }
            Object[] fields = this.dbfile2fields.get(dbFileName);
            if (this.verbose) {
                Log.info("Create database from file '" + dbFileName + "', fields: " + Arrays.toString(fields));
            }
            VariantDatabase variantDatabase = new VariantDatabase(dbFileName, dbDir, (String[])fields);
            variantDatabase.setVerbose(this.verbose);
            variantDatabase.create();
        }
        if (this.verbose) {
            Log.info("Create databases: Done!");
        }
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> headerInfos = super.headers();
        for (VariantDatabase db : this.variantDatabases) {
            headerInfos.addAll(db.vcfHeaders());
        }
        if (this.addAnnotated) {
            headerInfos.add(VcfHeaderEntry.factory("##INFO=<ID=ANNOTATED,Number=0,Type=Flag,Description=\"Variant was annotated\">"));
        }
        return headerInfos;
    }

    @Override
    public void init() {
        super.init();
        this.emptyIfNotFound = true;
        this.dbFileNames = new ArrayList<String>();
        this.variantDatabases = new ArrayList<VariantDatabase>();
        this.dbfile2fields = new HashMap<String, String[]>();
        this.dbfile2prefix = new HashMap<String, String>();
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        String latestDbName = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-addannotated": {
                        this.addAnnotated = true;
                        break;
                    }
                    case "-create": {
                        this.create = true;
                        break;
                    }
                    case "-dbfile": {
                        if (args.length > i2 + 1) {
                            latestDbName = args[++i2];
                            this.add(latestDbName);
                            break;
                        }
                        this.usage("Missing parameter for '-dbfile'");
                        break;
                    }
                    case "-fields": {
                        if (args.length > i2 + 1) {
                            if (latestDbName == null) {
                                this.usage("Missing database file name for '-fields'. Option '-fields' must be precedded by the corresponding '-dbfile' option");
                            }
                            String[] fields = args[++i2].split(",");
                            this.dbfile2fields.put(latestDbName, fields);
                            break;
                        }
                        this.usage("Missing parameter for '-fields'");
                        break;
                    }
                    case "-prefix": {
                        if (args.length > i2 + 1) {
                            if (latestDbName == null) {
                                this.usage("Missing database file name for '-prefix'. Option '-prefix' must be precedded by the corresponding '-dbfile' option");
                            }
                            this.dbfile2prefix.put(latestDbName, args[++i2]);
                            break;
                        }
                        this.usage("Missing parameter for '-prefix'");
                        break;
                    }
                    default: {
                        this.usage("Unknown command line option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("Unknown extra parameter '" + arg + "'");
        }
        if (this.dbFileNames.isEmpty()) {
            this.usage("Missing database file options: -dbfile file.vcf");
        }
        if (this.create) {
            if (this.dbfile2fields.isEmpty()) {
                this.usage("Missing fields for database creation: -fields field_1,..,field_N");
            }
            for (String dbFileName : this.dbFileNames) {
                if (this.dbfile2fields.containsKey(dbFileName)) continue;
                this.usage("Missing fields for database '" + dbFileName + "', e.g: -dbfile '" + dbFileName + "' -fields field_1,..,field_N");
            }
        } else if (this.vcfInputFile == null) {
            this.usage("Missing VCF input file");
        }
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        if (this.create) {
            this.create();
            return null;
        }
        return this.annotate(createList);
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage:");
        System.err.println("\tCreate databases:");
        System.err.println("\t           java -jar " + SnpSift.class.getSimpleName() + ".jar " + this.command + " \\");
        System.err.println("\t             -create \\");
        System.err.println("\t             -dbfile database_1.vcf -fields field_1,field_2,...,field_N \\");
        System.err.println("\t             -dbfile database_2.vcf -fields field_1,field_2,...,field_N \\");
        System.err.println("\t             -dbfile database_N.vcf -fields field_1,field_2,...,field_N");
        System.err.println("\n\tAnnotate:");
        System.err.println("\t           java -jar " + SnpSift.class.getSimpleName() + ".jar " + this.command + " \\");
        System.err.println("\t             [-addAnnotated] \\");
        System.err.println("\t             -dbfile database_1.vcf -fields field_1,field_2,...,field_N [-prefix prefix_db_1] \\");
        System.err.println("\t             -dbfile database_2.vcf -fields field_1,field_2,...,field_N [-prefix prefix_db_2] \\");
        System.err.println("\t             -dbfile database_N.vcf -fields field_1,field_2,...,field_N [-prefix prefix_db_N] ");
        System.err.println("\t             [input.vcf] > output.vcf \\");
        System.err.println("\nCommand Options:");
        System.err.println("\t-addAnnotated                 : When annotating, add 'ANNOTATED' flag to every INFO field (regardless of whether annotations were added or not).");
        System.err.println("\t-create                       : Create one or more database/s from the VCF file/s using specific field/s for each database.");
        System.err.println("\t-dbfile file.vcf              : Use VCF file (either to create a database or to annotate).");
        System.err.println("\t-fields field_1,..,field_N    : Use VCF info fields when creating/annotating. Comma separated list, no spaces.");
        System.err.println("\t-prefix prefix_db             : When annoating, prepend 'prefix_db' to each annotated field name.");
        System.err.println("Note: When annotating, if 'input.vcf' is not provided, reads from STDIN.");
        System.err.println("Note: VCF files can be compressed with Gzip / Bgzip");
        System.exit(1);
    }
}

