/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpsift.SnpSift;

public class SnpSiftCmdAlleleMatrix
extends SnpSift {
    public static String SEPARATOR = "";
    public static int SHOW_EVERY = 1000;

    @Override
    public void parseArgs(String[] args) {
        if (args.length <= 0) {
            this.usage(null);
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (this.isOpt(arg)) continue;
            this.vcfInputFile = arg;
        }
    }

    public int processStr(VcfEntry vcfEntry, StringBuilder sbcodes) {
        String sep = "";
        int countNonRef = 0;
        for (VcfGenotype gen : vcfEntry.getVcfGenotypes()) {
            int score = gen.getGenotypeCode();
            String sc = ".";
            if (score >= 0) {
                sc = Integer.toString(score);
                if (score > 0) {
                    ++countNonRef;
                }
            }
            sbcodes.append(sep + sc);
            sep = SEPARATOR;
        }
        return countNonRef;
    }

    @Override
    public boolean run() {
        int i2 = 1;
        VcfFileIterator vcf = this.openVcfInputFile();
        for (VcfEntry ve : vcf) {
            if (vcf.isHeadeSection()) {
                System.out.print("#CHROM\tPOS\tREF\tALT");
                for (String sample : vcf.getVcfHeader().getSampleNames()) {
                    System.out.print("\t" + sample);
                }
                System.out.println("");
            }
            StringBuilder sbcodes = new StringBuilder();
            this.processStr(ve, sbcodes);
            System.out.println(ve.getChromosomeName() + "\t" + (ve.getStart() + 1) + "\t" + ve.getRef() + "\t" + ve.getAltsStr() + "\t" + sbcodes.toString());
            if (!this.verbose) continue;
            Gpr.showMark(i2++, SHOW_EVERY);
        }
        if (this.verbose) {
            Log.info("Done");
        }
        return true;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar alleleMat file.vcf > allele.matrix.txt");
        System.exit(1);
    }
}

