/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import org.snpeff.interval.Gene;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;

public class VcfLof {
    String geneName;
    String geneId;
    int numTranscripts;
    double percentAffected;
    VcfEntry vcfEntry;

    public static int fieldNum(String name) {
        int fieldNum = 0;
        if (name.equals("LOF.GENE")) {
            return fieldNum;
        }
        ++fieldNum;
        if (name.equals("LOF.GENEID")) {
            return fieldNum;
        }
        ++fieldNum;
        if (name.equals("LOF.NUMTR")) {
            return fieldNum;
        }
        ++fieldNum;
        if (name.equals("LOF.PERC")) {
            return fieldNum;
        }
        ++fieldNum;
        return -1;
    }

    public VcfLof(Gene gene, double percentAffected) {
        this.geneName = gene.getGeneName();
        this.geneId = gene.getId();
        this.numTranscripts = gene.numChilds();
        this.percentAffected = percentAffected;
    }

    public VcfLof(String lofStr) {
        this.parse(lofStr);
    }

    public VcfLof(String geneName, String geneId, int numTranscripts, double percentAffected) {
        this.geneName = geneName;
        this.geneId = geneId;
        this.numTranscripts = numTranscripts;
        this.percentAffected = percentAffected;
    }

    public VcfLof(VcfEntry vcfEntry, String lofStr) {
        this.vcfEntry = vcfEntry;
        this.parse(lofStr);
    }

    public String getGeneId() {
        return this.geneId;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public int getNumTranscripts() {
        return this.numTranscripts;
    }

    public double getPercentAffected() {
        return this.percentAffected;
    }

    public String getPercentAffectedStr() {
        return String.format("%.1f", 100.0 * this.percentAffected);
    }

    public VcfEntry getVcfEntry() {
        return this.vcfEntry;
    }

    void parse(String lof) {
        if (lof.startsWith("(")) {
            lof = lof.substring(1);
        }
        if (lof.endsWith(")")) {
            lof = lof.substring(0, lof.length() - 1);
        }
        String[] lofFields = lof.split("\\|");
        try {
            int index = 0;
            if (lofFields.length > index && !lofFields[index].isEmpty()) {
                this.geneName = lofFields[index];
            }
            if (lofFields.length > ++index && !lofFields[index].isEmpty()) {
                this.geneId = lofFields[index];
            }
            if (lofFields.length > ++index && !lofFields[index].isEmpty()) {
                this.numTranscripts = Gpr.parseIntSafe(lofFields[index]);
            }
            if (lofFields.length > ++index && !lofFields[index].isEmpty()) {
                this.percentAffected = Gpr.parseDoubleSafe(lofFields[index]);
            }
            ++index;
        }
        catch (Exception e) {
            Object fields = "";
            for (int i2 = 0; i2 < lofFields.length; ++i2) {
                fields = (String)fields + "\t" + i2 + " : '" + lofFields[i2] + "'\n";
            }
            throw new RuntimeException("Error parsing: '" + lof + "'\n" + (String)fields, e);
        }
    }

    public String toString() {
        return String.format("(%s|%s|%d|%.2f)", VcfEntry.vcfInfoValueSafe(this.geneName), VcfEntry.vcfInfoValueSafe(this.geneId), this.numTranscripts, this.percentAffected);
    }
}

