/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.HashMap;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;

public class VcfGenotype {
    public static final String GT_FIELD_DEPTH_OF_COVERAGE = "DP";
    public static final String GT_FIELD_ALLELIC_DEPTH_OF_COVERAGE = "AD";
    String values;
    int[] genotype;
    int ploidy;
    boolean phased;
    double gQuality;
    int depth;
    int[] genotypeLikelihoodPhred;
    HashMap<String, String> fields;
    VcfEntry vcfEntry;

    public VcfGenotype(VcfEntry vcfEntry, String format, String values) {
        this.vcfEntry = vcfEntry;
        this.values = values;
    }

    public void add(String name, String value) {
        if (value.indexOf(32) >= 0 || value.indexOf(9) >= 0 || value.indexOf(61) >= 0 || value.indexOf(58) >= 0) {
            throw new RuntimeException("Error: Attempt to add a value containin illegal characters: no white-space, semicolons, colons, or equals-signs permitted\n\tname : '" + name + "'\n\tvalue : '" + value + "'");
        }
        if (this.vcfEntry.getFormat().indexOf(name) < 0) {
            throw new RuntimeException("Error Attempt to add a field (name=" + name + ") that is not present in FORMAT field. Use VcfEntry.addFormat() method first!");
        }
        this.values = this.values + (this.values.endsWith(":") ? "" : ":") + value;
        if (this.fields != null) {
            this.fields.put(name, value);
        }
    }

    public int depth() {
        String dp = this.get(GT_FIELD_DEPTH_OF_COVERAGE);
        if (dp != null && !dp.isEmpty()) {
            return Gpr.parseIntSafe(dp);
        }
        String ads = this.get(GT_FIELD_ALLELIC_DEPTH_OF_COVERAGE);
        if (ads == null || ads.isEmpty()) {
            return -1;
        }
        int depth = 0;
        for (String ad : ads.split(",")) {
            depth += Gpr.parseIntSafe(ad);
        }
        return depth;
    }

    public String get(String fieldName) {
        this.parseFields();
        return this.fields.get(fieldName);
    }

    public int[] getGenotype() {
        this.parseFields();
        return this.genotype;
    }

    public String getGenotype(int idx) {
        this.parseFields();
        if (this.genotype == null) {
            return "";
        }
        int num = this.genotype[idx];
        if (num < 0) {
            return "";
        }
        return num == 0 ? this.vcfEntry.getRef() : this.vcfEntry.getAlts()[num - 1];
    }

    public int getGenotypeCode() {
        this.parseFields();
        if (this.genotype == null) {
            return -1;
        }
        int code = 0;
        for (int i2 = 0; i2 < this.genotype.length; ++i2) {
            if (this.genotype[i2] < 0) {
                return -1;
            }
            code += this.genotype[i2] > 0 ? 1 : 0;
        }
        return code;
    }

    public int getGenotypeCodeIgnoreMissing() {
        this.parseFields();
        if (this.genotype == null) {
            return -1;
        }
        int code = 0;
        for (int i2 = 0; i2 < this.genotype.length; ++i2) {
            code += this.genotype[i2] > 0 ? 1 : 0;
        }
        return code;
    }

    public String getGenotypeStr() {
        this.parseFields();
        StringBuilder sb = new StringBuilder();
        if (this.genotype != null) {
            for (int i2 = 0; i2 < this.genotype.length; ++i2) {
                int num = this.genotype[i2];
                String gen = ".";
                if (num == 0) {
                    gen = this.vcfEntry.getRef();
                } else if (num > 0) {
                    gen = this.vcfEntry.getAlts()[num - 1];
                }
                sb.append(gen);
                if (i2 >= this.genotype.length - 1) continue;
                if (this.isPhased()) {
                    sb.append("|");
                    continue;
                }
                sb.append("/");
            }
        }
        return sb.toString();
    }

    public VcfEntry getVcfEntry() {
        return this.vcfEntry;
    }

    String gtMissing() {
        int len = this.plodity();
        if (len <= 1) {
            return ".";
        }
        if (len == 2) {
            return "./.";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('.');
        for (int i2 = 1; i2 < len; ++i2) {
            sb.append("/.");
        }
        return sb.toString();
    }

    public boolean isHeterozygous() {
        return !this.isHomozygous();
    }

    public boolean isHomozygous() {
        this.parseFields();
        if (this.genotype != null) {
            for (int i2 = 1; i2 < this.genotype.length; ++i2) {
                if (this.genotype[i2] == this.genotype[i2 - 1]) continue;
                return false;
            }
            return true;
        }
        return this.vcfEntry.isBiAllelic();
    }

    public boolean isHomozygousAlt() {
        this.parseFields();
        if (this.genotype != null) {
            for (int i2 = 1; i2 < this.genotype.length; ++i2) {
                if (this.genotype[i2] == this.genotype[i2 - 1]) continue;
                return false;
            }
            return true;
        }
        return this.vcfEntry.isBiAllelic();
    }

    public boolean isMissing() {
        this.parseFields();
        if (this.genotype == null) {
            return true;
        }
        for (int i2 = 0; i2 < this.genotype.length; ++i2) {
            if (this.genotype[i2] >= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isPhased() {
        this.parseFields();
        return this.phased;
    }

    public boolean isRef() {
        if (this.values.isEmpty()) {
            return false;
        }
        this.parseFields();
        if (this.genotype != null) {
            for (int i2 = 0; i2 < this.genotype.length; ++i2) {
                if (this.genotype[i2] <= 0) continue;
                return false;
            }
            return true;
        }
        return !this.vcfEntry.isVariant();
    }

    public boolean isVariant() {
        if (this.values.isEmpty()) {
            return false;
        }
        this.parseFields();
        if (this.genotype != null) {
            for (int i2 = 0; i2 < this.genotype.length; ++i2) {
                if (this.genotype[i2] <= 0) continue;
                return true;
            }
            return false;
        }
        return this.vcfEntry.isVariant();
    }

    void parseFields() {
        if (this.fields != null) {
            return;
        }
        try {
            this.fields = new HashMap();
            if (this.values.isEmpty()) {
                return;
            }
            String[] format = this.vcfEntry.getFormatFields();
            String[] fieldValues = this.values.split(":");
            int min = Math.min(fieldValues.length, format.length);
            for (int i2 = 0; i2 < min; ++i2) {
                String name = format[i2];
                String value = fieldValues[i2];
                this.fields.put(name, value);
                if (name.equals("GT")) {
                    this.parseGt(value);
                    continue;
                }
                if (name.equals("PL")) {
                    this.parsePl(value);
                    continue;
                }
                if (!name.equals("GQ")) continue;
                this.gQuality = Gpr.parseDoubleSafe(value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing fields on line:\n\tFormat   : '" + this.vcfEntry.getFormat() + "'\n\tValues   : '" + this.values + "'\n\tVcf line : " + String.valueOf(this.vcfEntry), e);
        }
    }

    void parseGt(String value) {
        String[] gtStr = null;
        if (value.indexOf(124) >= 0) {
            gtStr = value.split("\\|");
            this.phased = true;
        } else {
            gtStr = value.split("/");
            this.phased = false;
        }
        this.genotype = new int[gtStr.length];
        for (int i2 = 0; i2 < this.genotype.length; ++i2) {
            if (gtStr[i2].isEmpty() || gtStr[i2].equals(".")) {
                this.genotype[i2] = -1;
                continue;
            }
            this.genotype[i2] = Gpr.parseIntSafe(gtStr[i2]);
            if (this.genotype[i2] - 1 < this.vcfEntry.getAlts().length) continue;
            boolean plural = this.vcfEntry.getAlts().length > 1;
            throw new RuntimeException("Error: Bad genotype field '" + value + "'. Genotype says '" + this.genotype[i2] + "' but there " + (plural ? "are" : "is") + " only '" + this.vcfEntry.getAlts().length + "' allele" + (plural ? "s" : "") + " ('" + this.vcfEntry.getAltsStr() + "').");
        }
    }

    void parsePl(String value) {
        String[] plStr = value.split(",");
        this.genotypeLikelihoodPhred = new int[plStr.length];
        for (int i2 = 0; i2 < plStr.length; ++i2) {
            this.genotypeLikelihoodPhred[i2] = Gpr.parseIntSafe(plStr[i2]);
        }
    }

    public int plodity() {
        int[] gt = this.getGenotype();
        return gt == null ? 0 : gt.length;
    }

    public void set(String gtFieldName, String gtValue) {
        String[] ffields = this.vcfEntry.getFormatFields();
        if (ffields.length < 1) {
            return;
        }
        if (gtFieldName.equals("GT") && gtValue.equals(".")) {
            gtValue = this.gtMissing();
        }
        StringBuilder gtsb = new StringBuilder();
        for (String fieldName : ffields) {
            String value = this.get(fieldName);
            if (fieldName.equals(gtFieldName)) {
                value = gtValue;
            }
            if (value == null) {
                value = ".";
            }
            gtsb.append((gtsb.length() > 0 ? ":" : "") + value);
        }
        this.values = gtsb.toString();
        this.fields = null;
    }

    public void setGenotype(String gtValue) {
        this.set("GT", gtValue);
    }

    public String toString() {
        return this.values.isEmpty() ? "." : this.values;
    }
}

